// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> A string property that indicates the action to be performed on the Flink job. It can have one of the following enum values =&gt; NEW, UPDATE, STATELESS_UPDATE, STOP, START, CANCEL, SAVEPOINT, LIST_SAVEPOINT, or DELETE. </summary>
    public readonly partial struct FlinkJobAction : IEquatable<FlinkJobAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FlinkJobAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FlinkJobAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NewValue = "NEW";
        private const string UpdateValue = "UPDATE";
        private const string StatelessUpdateValue = "STATELESS_UPDATE";
        private const string StopValue = "STOP";
        private const string StartValue = "START";
        private const string CancelValue = "CANCEL";
        private const string SavepointValue = "SAVEPOINT";
        private const string ListSavepointValue = "LIST_SAVEPOINT";
        private const string DeleteValue = "DELETE";
        private const string LastStateUpdateValue = "LAST_STATE_UPDATE";
        private const string RELaunchValue = "RE_LAUNCH";

        /// <summary> NEW. </summary>
        public static FlinkJobAction New { get; } = new FlinkJobAction(NewValue);
        /// <summary> UPDATE. </summary>
        public static FlinkJobAction Update { get; } = new FlinkJobAction(UpdateValue);
        /// <summary> STATELESS_UPDATE. </summary>
        public static FlinkJobAction StatelessUpdate { get; } = new FlinkJobAction(StatelessUpdateValue);
        /// <summary> STOP. </summary>
        public static FlinkJobAction Stop { get; } = new FlinkJobAction(StopValue);
        /// <summary> START. </summary>
        public static FlinkJobAction Start { get; } = new FlinkJobAction(StartValue);
        /// <summary> CANCEL. </summary>
        public static FlinkJobAction Cancel { get; } = new FlinkJobAction(CancelValue);
        /// <summary> SAVEPOINT. </summary>
        public static FlinkJobAction Savepoint { get; } = new FlinkJobAction(SavepointValue);
        /// <summary> LIST_SAVEPOINT. </summary>
        public static FlinkJobAction ListSavepoint { get; } = new FlinkJobAction(ListSavepointValue);
        /// <summary> DELETE. </summary>
        public static FlinkJobAction Delete { get; } = new FlinkJobAction(DeleteValue);
        /// <summary> LAST_STATE_UPDATE. </summary>
        public static FlinkJobAction LastStateUpdate { get; } = new FlinkJobAction(LastStateUpdateValue);
        /// <summary> RE_LAUNCH. </summary>
        public static FlinkJobAction RELaunch { get; } = new FlinkJobAction(RELaunchValue);
        /// <summary> Determines if two <see cref="FlinkJobAction"/> values are the same. </summary>
        public static bool operator ==(FlinkJobAction left, FlinkJobAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FlinkJobAction"/> values are not the same. </summary>
        public static bool operator !=(FlinkJobAction left, FlinkJobAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FlinkJobAction"/>. </summary>
        public static implicit operator FlinkJobAction(string value) => new FlinkJobAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FlinkJobAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FlinkJobAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
