// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Hive Catalog Option for Flink cluster. </summary>
    public partial class FlinkHiveCatalogOption
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FlinkHiveCatalogOption"/>. </summary>
        /// <param name="metastoreDBConnectionUriString"> Connection string for hive metastore database. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metastoreDBConnectionUriString"/> is null. </exception>
        public FlinkHiveCatalogOption(string metastoreDBConnectionUriString)
        {
            Argument.AssertNotNull(metastoreDBConnectionUriString, nameof(metastoreDBConnectionUriString));

            MetastoreDBConnectionUriString = metastoreDBConnectionUriString;
        }

        /// <summary> Initializes a new instance of <see cref="FlinkHiveCatalogOption"/>. </summary>
        /// <param name="metastoreDBConnectionAuthenticationMode"> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </param>
        /// <param name="metastoreDBConnectionPasswordSecret"> Secret reference name from secretsProfile.secrets containing password for database connection. </param>
        /// <param name="metastoreDBConnectionUriString"> Connection string for hive metastore database. </param>
        /// <param name="metastoreDBConnectionUserName"> User name for database connection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FlinkHiveCatalogOption(MetastoreDBConnectionAuthenticationMode? metastoreDBConnectionAuthenticationMode, string metastoreDBConnectionPasswordSecret, string metastoreDBConnectionUriString, string metastoreDBConnectionUserName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MetastoreDBConnectionAuthenticationMode = metastoreDBConnectionAuthenticationMode;
            MetastoreDBConnectionPasswordSecret = metastoreDBConnectionPasswordSecret;
            MetastoreDBConnectionUriString = metastoreDBConnectionUriString;
            MetastoreDBConnectionUserName = metastoreDBConnectionUserName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FlinkHiveCatalogOption"/> for deserialization. </summary>
        internal FlinkHiveCatalogOption()
        {
        }

        /// <summary> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </summary>
        [WirePath("metastoreDbConnectionAuthenticationMode")]
        public MetastoreDBConnectionAuthenticationMode? MetastoreDBConnectionAuthenticationMode { get; set; }
        /// <summary> Secret reference name from secretsProfile.secrets containing password for database connection. </summary>
        [WirePath("metastoreDbConnectionPasswordSecret")]
        public string MetastoreDBConnectionPasswordSecret { get; set; }
        /// <summary> Connection string for hive metastore database. </summary>
        [WirePath("metastoreDbConnectionURL")]
        public string MetastoreDBConnectionUriString { get; set; }
        /// <summary> User name for database connection. </summary>
        [WirePath("metastoreDbConnectionUserName")]
        public string MetastoreDBConnectionUserName { get; set; }
    }
}
