// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Kafka disk storage profile. </summary>
    public partial class DiskStorageProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiskStorageProfile"/>. </summary>
        /// <param name="dataDiskSize"> Managed Disk size in GB. The maximum supported disk size for Standard and Premium HDD/SSD is 32TB, except for Premium SSD v2, which supports up to 64TB. </param>
        /// <param name="dataDiskType"> Managed Disk Type. </param>
        public DiskStorageProfile(int dataDiskSize, DataDiskType dataDiskType)
        {
            DataDiskSize = dataDiskSize;
            DataDiskType = dataDiskType;
        }

        /// <summary> Initializes a new instance of <see cref="DiskStorageProfile"/>. </summary>
        /// <param name="dataDiskSize"> Managed Disk size in GB. The maximum supported disk size for Standard and Premium HDD/SSD is 32TB, except for Premium SSD v2, which supports up to 64TB. </param>
        /// <param name="dataDiskType"> Managed Disk Type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiskStorageProfile(int dataDiskSize, DataDiskType dataDiskType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataDiskSize = dataDiskSize;
            DataDiskType = dataDiskType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DiskStorageProfile"/> for deserialization. </summary>
        internal DiskStorageProfile()
        {
        }

        /// <summary> Managed Disk size in GB. The maximum supported disk size for Standard and Premium HDD/SSD is 32TB, except for Premium SSD v2, which supports up to 64TB. </summary>
        [WirePath("dataDiskSize")]
        public int DataDiskSize { get; set; }
        /// <summary> Managed Disk Type. </summary>
        [WirePath("dataDiskType")]
        public DataDiskType DataDiskType { get; set; }
    }
}
