// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> A string property that indicates the deployment mode of Flink cluster. It can have one of the following enum values =&gt; Application, Session. Default value is Session. </summary>
    public readonly partial struct DeploymentMode : IEquatable<DeploymentMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeploymentMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeploymentMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApplicationValue = "Application";
        private const string SessionValue = "Session";

        /// <summary> Application. </summary>
        public static DeploymentMode Application { get; } = new DeploymentMode(ApplicationValue);
        /// <summary> Session. </summary>
        public static DeploymentMode Session { get; } = new DeploymentMode(SessionValue);
        /// <summary> Determines if two <see cref="DeploymentMode"/> values are the same. </summary>
        public static bool operator ==(DeploymentMode left, DeploymentMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeploymentMode"/> values are not the same. </summary>
        public static bool operator !=(DeploymentMode left, DeploymentMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeploymentMode"/>. </summary>
        public static implicit operator DeploymentMode(string value) => new DeploymentMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeploymentMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeploymentMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
