// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Managed Disk Type. </summary>
    public readonly partial struct DataDiskType : IEquatable<DataDiskType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataDiskType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataDiskType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardHddLrsValue = "Standard_HDD_LRS";
        private const string StandardSsdLrsValue = "Standard_SSD_LRS";
        private const string StandardSsdZrsValue = "Standard_SSD_ZRS";
        private const string PremiumSsdLrsValue = "Premium_SSD_LRS";
        private const string PremiumSsdZrsValue = "Premium_SSD_ZRS";
        private const string PremiumSsdV2LrsValue = "Premium_SSD_v2_LRS";

        /// <summary> Standard_HDD_LRS. </summary>
        public static DataDiskType StandardHddLrs { get; } = new DataDiskType(StandardHddLrsValue);
        /// <summary> Standard_SSD_LRS. </summary>
        public static DataDiskType StandardSsdLrs { get; } = new DataDiskType(StandardSsdLrsValue);
        /// <summary> Standard_SSD_ZRS. </summary>
        public static DataDiskType StandardSsdZrs { get; } = new DataDiskType(StandardSsdZrsValue);
        /// <summary> Premium_SSD_LRS. </summary>
        public static DataDiskType PremiumSsdLrs { get; } = new DataDiskType(PremiumSsdLrsValue);
        /// <summary> Premium_SSD_ZRS. </summary>
        public static DataDiskType PremiumSsdZrs { get; } = new DataDiskType(PremiumSsdZrsValue);
        /// <summary> Premium_SSD_v2_LRS. </summary>
        public static DataDiskType PremiumSsdV2Lrs { get; } = new DataDiskType(PremiumSsdV2LrsValue);
        /// <summary> Determines if two <see cref="DataDiskType"/> values are the same. </summary>
        public static bool operator ==(DataDiskType left, DataDiskType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataDiskType"/> values are not the same. </summary>
        public static bool operator !=(DataDiskType left, DataDiskType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataDiskType"/>. </summary>
        public static implicit operator DataDiskType(string value) => new DataDiskType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataDiskType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataDiskType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
