// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The authentication mode to connect to your Hive metastore database. More details: https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization. </summary>
    public readonly partial struct DBConnectionAuthenticationMode : IEquatable<DBConnectionAuthenticationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DBConnectionAuthenticationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DBConnectionAuthenticationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlAuthValue = "SqlAuth";
        private const string IdentityAuthValue = "IdentityAuth";

        /// <summary> The password-based authentication to connect to your Hive metastore database. </summary>
        public static DBConnectionAuthenticationMode SqlAuth { get; } = new DBConnectionAuthenticationMode(SqlAuthValue);
        /// <summary> The managed-identity-based authentication to connect to your Hive metastore database. </summary>
        public static DBConnectionAuthenticationMode IdentityAuth { get; } = new DBConnectionAuthenticationMode(IdentityAuthValue);
        /// <summary> Determines if two <see cref="DBConnectionAuthenticationMode"/> values are the same. </summary>
        public static bool operator ==(DBConnectionAuthenticationMode left, DBConnectionAuthenticationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DBConnectionAuthenticationMode"/> values are not the same. </summary>
        public static bool operator !=(DBConnectionAuthenticationMode left, DBConnectionAuthenticationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DBConnectionAuthenticationMode"/>. </summary>
        public static implicit operator DBConnectionAuthenticationMode(string value) => new DBConnectionAuthenticationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DBConnectionAuthenticationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DBConnectionAuthenticationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
