// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Current AKS version's status: whether it is deprecated or supported. </summary>
    public readonly partial struct CurrentClusterPoolAksVersionStatus : IEquatable<CurrentClusterPoolAksVersionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CurrentClusterPoolAksVersionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CurrentClusterPoolAksVersionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeprecatedValue = "Deprecated";
        private const string SupportedValue = "Supported";

        /// <summary> Deprecated. </summary>
        public static CurrentClusterPoolAksVersionStatus Deprecated { get; } = new CurrentClusterPoolAksVersionStatus(DeprecatedValue);
        /// <summary> Supported. </summary>
        public static CurrentClusterPoolAksVersionStatus Supported { get; } = new CurrentClusterPoolAksVersionStatus(SupportedValue);
        /// <summary> Determines if two <see cref="CurrentClusterPoolAksVersionStatus"/> values are the same. </summary>
        public static bool operator ==(CurrentClusterPoolAksVersionStatus left, CurrentClusterPoolAksVersionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CurrentClusterPoolAksVersionStatus"/> values are not the same. </summary>
        public static bool operator !=(CurrentClusterPoolAksVersionStatus left, CurrentClusterPoolAksVersionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CurrentClusterPoolAksVersionStatus"/>. </summary>
        public static implicit operator CurrentClusterPoolAksVersionStatus(string value) => new CurrentClusterPoolAksVersionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CurrentClusterPoolAksVersionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CurrentClusterPoolAksVersionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
