// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The cpu and memory requirement definition. </summary>
    public partial class ComputeResourceRequirement
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeResourceRequirement"/>. </summary>
        /// <param name="cpu"> The required CPU. </param>
        /// <param name="memory"> The required memory in MB, Container memory will be 110 percentile. </param>
        public ComputeResourceRequirement(float cpu, long memory)
        {
            Cpu = cpu;
            Memory = memory;
        }

        /// <summary> Initializes a new instance of <see cref="ComputeResourceRequirement"/>. </summary>
        /// <param name="cpu"> The required CPU. </param>
        /// <param name="memory"> The required memory in MB, Container memory will be 110 percentile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeResourceRequirement(float cpu, long memory, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Cpu = cpu;
            Memory = memory;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ComputeResourceRequirement"/> for deserialization. </summary>
        internal ComputeResourceRequirement()
        {
        }

        /// <summary> The required CPU. </summary>
        [WirePath("cpu")]
        public float Cpu { get; set; }
        /// <summary> The required memory in MB, Container memory will be 110 percentile. </summary>
        [WirePath("memory")]
        public long Memory { get; set; }
    }
}
