// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster version properties. </summary>
    public partial class ClusterVersionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterVersionProperties"/>. </summary>
        public ClusterVersionProperties()
        {
            Components = new ChangeTrackingList<ClusterComponentItem>();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterVersionProperties"/>. </summary>
        /// <param name="clusterType"> The type of cluster. </param>
        /// <param name="clusterVersion"> Version with three part. </param>
        /// <param name="ossVersion"> Version with three part. </param>
        /// <param name="clusterPoolVersion"> The two part cluster pool version. If the cluster version is before cluster pool version on-board, the return value will be empty string. </param>
        /// <param name="isPreview"> Indicate if this version is in preview or not. </param>
        /// <param name="components"> Component list of this cluster type and version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterVersionProperties(string clusterType, string clusterVersion, string ossVersion, string clusterPoolVersion, bool? isPreview, IReadOnlyList<ClusterComponentItem> components, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClusterType = clusterType;
            ClusterVersion = clusterVersion;
            OssVersion = ossVersion;
            ClusterPoolVersion = clusterPoolVersion;
            IsPreview = isPreview;
            Components = components;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of cluster. </summary>
        [WirePath("clusterType")]
        public string ClusterType { get; set; }
        /// <summary> Version with three part. </summary>
        [WirePath("clusterVersion")]
        public string ClusterVersion { get; set; }
        /// <summary> Version with three part. </summary>
        [WirePath("ossVersion")]
        public string OssVersion { get; set; }
        /// <summary> The two part cluster pool version. If the cluster version is before cluster pool version on-board, the return value will be empty string. </summary>
        [WirePath("clusterPoolVersion")]
        public string ClusterPoolVersion { get; set; }
        /// <summary> Indicate if this version is in preview or not. </summary>
        [WirePath("isPreview")]
        public bool? IsPreview { get; set; }
        /// <summary> Component list of this cluster type and version. </summary>
        [WirePath("components")]
        public IReadOnlyList<ClusterComponentItem> Components { get; }
    }
}
