// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Type of upgrade. </summary>
    internal readonly partial struct ClusterUpgradeType : IEquatable<ClusterUpgradeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterUpgradeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AKSPatchUpgradeValue = "AKSPatchUpgrade";
        private const string HotfixUpgradeValue = "HotfixUpgrade";
        private const string PatchVersionUpgradeValue = "PatchVersionUpgrade";

        /// <summary> AKSPatchUpgrade. </summary>
        public static ClusterUpgradeType AKSPatchUpgrade { get; } = new ClusterUpgradeType(AKSPatchUpgradeValue);
        /// <summary> HotfixUpgrade. </summary>
        public static ClusterUpgradeType HotfixUpgrade { get; } = new ClusterUpgradeType(HotfixUpgradeValue);
        /// <summary> PatchVersionUpgrade. </summary>
        public static ClusterUpgradeType PatchVersionUpgrade { get; } = new ClusterUpgradeType(PatchVersionUpgradeValue);
        /// <summary> Determines if two <see cref="ClusterUpgradeType"/> values are the same. </summary>
        public static bool operator ==(ClusterUpgradeType left, ClusterUpgradeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterUpgradeType"/> values are not the same. </summary>
        public static bool operator !=(ClusterUpgradeType left, ClusterUpgradeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterUpgradeType"/>. </summary>
        public static implicit operator ClusterUpgradeType(string value) => new ClusterUpgradeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterUpgradeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterUpgradeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
