// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Severity of this upgrade. </summary>
    public readonly partial struct ClusterUpgradeSeverityType : IEquatable<ClusterUpgradeSeverityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeSeverityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterUpgradeSeverityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "low";
        private const string MediumValue = "medium";
        private const string HighValue = "high";
        private const string CriticalValue = "critical";

        /// <summary> low. </summary>
        public static ClusterUpgradeSeverityType Low { get; } = new ClusterUpgradeSeverityType(LowValue);
        /// <summary> medium. </summary>
        public static ClusterUpgradeSeverityType Medium { get; } = new ClusterUpgradeSeverityType(MediumValue);
        /// <summary> high. </summary>
        public static ClusterUpgradeSeverityType High { get; } = new ClusterUpgradeSeverityType(HighValue);
        /// <summary> critical. </summary>
        public static ClusterUpgradeSeverityType Critical { get; } = new ClusterUpgradeSeverityType(CriticalValue);
        /// <summary> Determines if two <see cref="ClusterUpgradeSeverityType"/> values are the same. </summary>
        public static bool operator ==(ClusterUpgradeSeverityType left, ClusterUpgradeSeverityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterUpgradeSeverityType"/> values are not the same. </summary>
        public static bool operator !=(ClusterUpgradeSeverityType left, ClusterUpgradeSeverityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterUpgradeSeverityType"/>. </summary>
        public static implicit operator ClusterUpgradeSeverityType(string value) => new ClusterUpgradeSeverityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterUpgradeSeverityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterUpgradeSeverityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
