// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties for manual rollback of cluster's upgrade. </summary>
    public partial class ClusterUpgradeRollbackProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeRollbackProperties"/>. </summary>
        /// <param name="upgradeHistory"> A specific upgrade history to rollback. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="upgradeHistory"/> is null. </exception>
        public ClusterUpgradeRollbackProperties(string upgradeHistory)
        {
            Argument.AssertNotNull(upgradeHistory, nameof(upgradeHistory));

            UpgradeHistory = upgradeHistory;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeRollbackProperties"/>. </summary>
        /// <param name="upgradeHistory"> A specific upgrade history to rollback. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterUpgradeRollbackProperties(string upgradeHistory, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UpgradeHistory = upgradeHistory;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeRollbackProperties"/> for deserialization. </summary>
        internal ClusterUpgradeRollbackProperties()
        {
        }

        /// <summary> A specific upgrade history to rollback. </summary>
        [WirePath("upgradeHistory")]
        public string UpgradeHistory { get; }
    }
}
