// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Result of this upgrade. </summary>
    public readonly partial struct ClusterUpgradeHistoryUpgradeResultType : IEquatable<ClusterUpgradeHistoryUpgradeResultType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeHistoryUpgradeResultType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterUpgradeHistoryUpgradeResultType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceedValue = "Succeed";
        private const string FailedValue = "Failed";

        /// <summary> Succeed. </summary>
        public static ClusterUpgradeHistoryUpgradeResultType Succeed { get; } = new ClusterUpgradeHistoryUpgradeResultType(SucceedValue);
        /// <summary> Failed. </summary>
        public static ClusterUpgradeHistoryUpgradeResultType Failed { get; } = new ClusterUpgradeHistoryUpgradeResultType(FailedValue);
        /// <summary> Determines if two <see cref="ClusterUpgradeHistoryUpgradeResultType"/> values are the same. </summary>
        public static bool operator ==(ClusterUpgradeHistoryUpgradeResultType left, ClusterUpgradeHistoryUpgradeResultType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterUpgradeHistoryUpgradeResultType"/> values are not the same. </summary>
        public static bool operator !=(ClusterUpgradeHistoryUpgradeResultType left, ClusterUpgradeHistoryUpgradeResultType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterUpgradeHistoryUpgradeResultType"/>. </summary>
        public static implicit operator ClusterUpgradeHistoryUpgradeResultType(string value) => new ClusterUpgradeHistoryUpgradeResultType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterUpgradeHistoryUpgradeResultType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterUpgradeHistoryUpgradeResultType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
