// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Type of upgrade. </summary>
    internal readonly partial struct ClusterUpgradeHistoryType : IEquatable<ClusterUpgradeHistoryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeHistoryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterUpgradeHistoryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AKSPatchUpgradeValue = "AKSPatchUpgrade";
        private const string HotfixUpgradeValue = "HotfixUpgrade";
        private const string HotfixUpgradeRollbackValue = "HotfixUpgradeRollback";
        private const string PatchVersionUpgradeValue = "PatchVersionUpgrade";
        private const string PatchVersionUpgradeRollbackValue = "PatchVersionUpgradeRollback";

        /// <summary> AKSPatchUpgrade. </summary>
        public static ClusterUpgradeHistoryType AKSPatchUpgrade { get; } = new ClusterUpgradeHistoryType(AKSPatchUpgradeValue);
        /// <summary> HotfixUpgrade. </summary>
        public static ClusterUpgradeHistoryType HotfixUpgrade { get; } = new ClusterUpgradeHistoryType(HotfixUpgradeValue);
        /// <summary> HotfixUpgradeRollback. </summary>
        public static ClusterUpgradeHistoryType HotfixUpgradeRollback { get; } = new ClusterUpgradeHistoryType(HotfixUpgradeRollbackValue);
        /// <summary> PatchVersionUpgrade. </summary>
        public static ClusterUpgradeHistoryType PatchVersionUpgrade { get; } = new ClusterUpgradeHistoryType(PatchVersionUpgradeValue);
        /// <summary> PatchVersionUpgradeRollback. </summary>
        public static ClusterUpgradeHistoryType PatchVersionUpgradeRollback { get; } = new ClusterUpgradeHistoryType(PatchVersionUpgradeRollbackValue);
        /// <summary> Determines if two <see cref="ClusterUpgradeHistoryType"/> values are the same. </summary>
        public static bool operator ==(ClusterUpgradeHistoryType left, ClusterUpgradeHistoryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterUpgradeHistoryType"/> values are not the same. </summary>
        public static bool operator !=(ClusterUpgradeHistoryType left, ClusterUpgradeHistoryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterUpgradeHistoryType"/>. </summary>
        public static implicit operator ClusterUpgradeHistoryType(string value) => new ClusterUpgradeHistoryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterUpgradeHistoryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterUpgradeHistoryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
