// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Severity of this upgrade. </summary>
    public readonly partial struct ClusterUpgradeHistorySeverityType : IEquatable<ClusterUpgradeHistorySeverityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeHistorySeverityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterUpgradeHistorySeverityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "low";
        private const string MediumValue = "medium";
        private const string HighValue = "high";
        private const string CriticalValue = "critical";

        /// <summary> low. </summary>
        public static ClusterUpgradeHistorySeverityType Low { get; } = new ClusterUpgradeHistorySeverityType(LowValue);
        /// <summary> medium. </summary>
        public static ClusterUpgradeHistorySeverityType Medium { get; } = new ClusterUpgradeHistorySeverityType(MediumValue);
        /// <summary> high. </summary>
        public static ClusterUpgradeHistorySeverityType High { get; } = new ClusterUpgradeHistorySeverityType(HighValue);
        /// <summary> critical. </summary>
        public static ClusterUpgradeHistorySeverityType Critical { get; } = new ClusterUpgradeHistorySeverityType(CriticalValue);
        /// <summary> Determines if two <see cref="ClusterUpgradeHistorySeverityType"/> values are the same. </summary>
        public static bool operator ==(ClusterUpgradeHistorySeverityType left, ClusterUpgradeHistorySeverityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterUpgradeHistorySeverityType"/> values are not the same. </summary>
        public static bool operator !=(ClusterUpgradeHistorySeverityType left, ClusterUpgradeHistorySeverityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterUpgradeHistorySeverityType"/>. </summary>
        public static implicit operator ClusterUpgradeHistorySeverityType(string value) => new ClusterUpgradeHistorySeverityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterUpgradeHistorySeverityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterUpgradeHistorySeverityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
