// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary>
    /// Properties of cluster upgrade history.
    /// Please note <see cref="ClusterUpgradeHistoryProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ClusterAksPatchUpgradeHistoryProperties"/>, <see cref="ClusterInPlaceUpgradeHistoryProperties"/>, <see cref="ClusterHotfixUpgradeHistoryProperties"/>, <see cref="ClusterHotfixUpgradeRollbackHistoryProperties"/>, <see cref="ClusterPatchVersionUpgradeHistoryProperties"/> and <see cref="ClusterPatchVersionUpgradeRollbackHistoryProperties"/>.
    /// </summary>
    public abstract partial class ClusterUpgradeHistoryProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeHistoryProperties"/>. </summary>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="utcTime"/> is null. </exception>
        protected ClusterUpgradeHistoryProperties(string utcTime, ClusterUpgradeHistoryUpgradeResultType upgradeResult)
        {
            Argument.AssertNotNull(utcTime, nameof(utcTime));

            UtcTime = utcTime;
            UpgradeResult = upgradeResult;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeHistoryProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterUpgradeHistoryProperties(ClusterUpgradeHistoryType upgradeType, string utcTime, ClusterUpgradeHistoryUpgradeResultType upgradeResult, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UpgradeType = upgradeType;
            UtcTime = utcTime;
            UpgradeResult = upgradeResult;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterUpgradeHistoryProperties"/> for deserialization. </summary>
        internal ClusterUpgradeHistoryProperties()
        {
        }

        /// <summary> Type of upgrade. </summary>
        internal ClusterUpgradeHistoryType UpgradeType { get; set; }
        /// <summary> Time when created this upgrade history. </summary>
        [WirePath("utcTime")]
        public string UtcTime { get; set; }
        /// <summary> Result of this upgrade. </summary>
        [WirePath("upgradeResult")]
        public ClusterUpgradeHistoryUpgradeResultType UpgradeResult { get; set; }
    }
}
