// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Ssh profile for the cluster. </summary>
    public partial class ClusterSshProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterSshProfile"/>. </summary>
        /// <param name="count"> Number of ssh pods per cluster. </param>
        public ClusterSshProfile(int count)
        {
            Count = count;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterSshProfile"/>. </summary>
        /// <param name="count"> Number of ssh pods per cluster. </param>
        /// <param name="podPrefix"> Prefix of the pod names. Pod number will be appended to the prefix. The ingress URLs for the pods will be available at &lt;clusterFqdn&gt;/&lt;sshBasePath&gt;/&lt;prefix&gt;-&lt;number&gt;. </param>
        /// <param name="vmSize"> The virtual machine SKU. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterSshProfile(int count, string podPrefix, string vmSize, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Count = count;
            PodPrefix = podPrefix;
            VmSize = vmSize;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterSshProfile"/> for deserialization. </summary>
        internal ClusterSshProfile()
        {
        }

        /// <summary> Number of ssh pods per cluster. </summary>
        [WirePath("count")]
        public int Count { get; set; }
        /// <summary> Prefix of the pod names. Pod number will be appended to the prefix. The ingress URLs for the pods will be available at &lt;clusterFqdn&gt;/&lt;sshBasePath&gt;/&lt;prefix&gt;-&lt;number&gt;. </summary>
        [WirePath("podPrefix")]
        public string PodPrefix { get; }
        /// <summary> The virtual machine SKU. </summary>
        [WirePath("vmSize")]
        public string VmSize { get; set; }
    }
}
