// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster configs per component. </summary>
    public partial class ClusterServiceConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterServiceConfig"/>. </summary>
        /// <param name="component"> Name of the component the config files should apply to. </param>
        /// <param name="files"> List of Config Files. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="component"/> or <paramref name="files"/> is null. </exception>
        public ClusterServiceConfig(string component, IEnumerable<ClusterConfigFile> files)
        {
            Argument.AssertNotNull(component, nameof(component));
            Argument.AssertNotNull(files, nameof(files));

            Component = component;
            Files = files.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterServiceConfig"/>. </summary>
        /// <param name="component"> Name of the component the config files should apply to. </param>
        /// <param name="files"> List of Config Files. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterServiceConfig(string component, IList<ClusterConfigFile> files, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Component = component;
            Files = files;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterServiceConfig"/> for deserialization. </summary>
        internal ClusterServiceConfig()
        {
        }

        /// <summary> Name of the component the config files should apply to. </summary>
        [WirePath("component")]
        public string Component { get; set; }
        /// <summary> List of Config Files. </summary>
        [WirePath("files")]
        public IList<ClusterConfigFile> Files { get; }
    }
}
