// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The cluster secret profile. </summary>
    public partial class ClusterSecretsProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterSecretsProfile"/>. </summary>
        /// <param name="keyVaultResourceId"> Name of the user Key Vault where all the cluster specific user secrets are stored. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyVaultResourceId"/> is null. </exception>
        public ClusterSecretsProfile(ResourceIdentifier keyVaultResourceId)
        {
            Argument.AssertNotNull(keyVaultResourceId, nameof(keyVaultResourceId));

            KeyVaultResourceId = keyVaultResourceId;
            Secrets = new ChangeTrackingList<ClusterSecretReference>();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterSecretsProfile"/>. </summary>
        /// <param name="keyVaultResourceId"> Name of the user Key Vault where all the cluster specific user secrets are stored. </param>
        /// <param name="secrets"> Properties of Key Vault secret. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterSecretsProfile(ResourceIdentifier keyVaultResourceId, IList<ClusterSecretReference> secrets, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultResourceId = keyVaultResourceId;
            Secrets = secrets;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterSecretsProfile"/> for deserialization. </summary>
        internal ClusterSecretsProfile()
        {
        }

        /// <summary> Name of the user Key Vault where all the cluster specific user secrets are stored. </summary>
        [WirePath("keyVaultResourceId")]
        public ResourceIdentifier KeyVaultResourceId { get; set; }
        /// <summary> Properties of Key Vault secret. </summary>
        [WirePath("secrets")]
        public IList<ClusterSecretReference> Secrets { get; }
    }
}
