// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties of a PyPi library in the cluster. </summary>
    public partial class ClusterPyPILibraryProperties : ClusterLibraryProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterPyPILibraryProperties"/>. </summary>
        /// <param name="name"> Name of the PyPi package. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public ClusterPyPILibraryProperties(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
            LibraryType = Type.Pypi;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPyPILibraryProperties"/>. </summary>
        /// <param name="libraryType"> Type of the library. </param>
        /// <param name="remarks"> Remark of the latest library management operation. </param>
        /// <param name="timestamp"> Timestamp of the latest library management operation. </param>
        /// <param name="status"> Status of the library. </param>
        /// <param name="message"> Error message of the library operation when a failure occurs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> Name of the PyPi package. </param>
        /// <param name="version"> Version of the PyPi package. </param>
        internal ClusterPyPILibraryProperties(Type libraryType, string remarks, DateTimeOffset? timestamp, Status? status, string message, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, string version) : base(libraryType, remarks, timestamp, status, message, serializedAdditionalRawData)
        {
            Name = name;
            Version = version;
            LibraryType = libraryType;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPyPILibraryProperties"/> for deserialization. </summary>
        internal ClusterPyPILibraryProperties()
        {
        }

        /// <summary> Name of the PyPi package. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Version of the PyPi package. </summary>
        [WirePath("version")]
        public string Version { get; set; }
    }
}
