// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster profile. </summary>
    public partial class ClusterProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterProfile"/>. </summary>
        /// <param name="clusterVersion"> Version with 3/4 part. </param>
        /// <param name="ossVersion"> Version with three part. </param>
        /// <param name="authorizationProfile"> Authorization profile with details of AAD user Ids and group Ids authorized for data plane access. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clusterVersion"/>, <paramref name="ossVersion"/> or <paramref name="authorizationProfile"/> is null. </exception>
        public ClusterProfile(string clusterVersion, string ossVersion, AuthorizationProfile authorizationProfile)
        {
            Argument.AssertNotNull(clusterVersion, nameof(clusterVersion));
            Argument.AssertNotNull(ossVersion, nameof(ossVersion));
            Argument.AssertNotNull(authorizationProfile, nameof(authorizationProfile));

            ClusterVersion = clusterVersion;
            OssVersion = ossVersion;
            Components = new ChangeTrackingList<ClusterComponentItem>();
            AuthorizationProfile = authorizationProfile;
            ServiceConfigsProfiles = new ChangeTrackingList<ClusterServiceConfigsProfile>();
            LlapProfile = new ChangeTrackingDictionary<string, BinaryData>();
            StubProfile = new ChangeTrackingDictionary<string, BinaryData>();
            ScriptActionProfiles = new ChangeTrackingList<ScriptActionProfile>();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterProfile"/>. </summary>
        /// <param name="clusterVersion"> Version with 3/4 part. </param>
        /// <param name="ossVersion"> Version with three part. </param>
        /// <param name="components"> Component list of this cluster type and version. </param>
        /// <param name="identityProfile"> This is deprecated. Please use managed identity profile instead. </param>
        /// <param name="managedIdentityProfile"> This property is required by Trino, Spark and Flink cluster but is optional for Kafka cluster. </param>
        /// <param name="authorizationProfile"> Authorization profile with details of AAD user Ids and group Ids authorized for data plane access. </param>
        /// <param name="secretsProfile"> The cluster secret profile. </param>
        /// <param name="serviceConfigsProfiles"> The service configs profiles. </param>
        /// <param name="connectivityProfile"> Cluster connectivity profile. </param>
        /// <param name="clusterAccessProfile"> Cluster access profile. </param>
        /// <param name="logAnalyticsProfile"> Cluster log analytics profile to enable or disable OMS agent for cluster. </param>
        /// <param name="prometheusProfile"> Cluster Prometheus profile. </param>
        /// <param name="sshProfile"> Ssh profile for the cluster. </param>
        /// <param name="autoscaleProfile"> This is the Autoscale profile for the cluster. This will allow customer to create cluster enabled with Autoscale. </param>
        /// <param name="rangerPluginProfile"> Cluster Ranger plugin profile. </param>
        /// <param name="kafkaProfile"> The Kafka cluster profile. </param>
        /// <param name="trinoProfile"> Trino Cluster profile. </param>
        /// <param name="llapProfile"> LLAP cluster profile. </param>
        /// <param name="flinkProfile"> The Flink cluster profile. </param>
        /// <param name="sparkProfile"> The spark cluster profile. </param>
        /// <param name="rangerProfile"> The ranger cluster profile. </param>
        /// <param name="stubProfile"> Stub cluster profile. </param>
        /// <param name="scriptActionProfiles"> The script action profile list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterProfile(string clusterVersion, string ossVersion, IReadOnlyList<ClusterComponentItem> components, HDInsightIdentityProfile identityProfile, ManagedIdentityProfile managedIdentityProfile, AuthorizationProfile authorizationProfile, ClusterSecretsProfile secretsProfile, IList<ClusterServiceConfigsProfile> serviceConfigsProfiles, ClusterConnectivityProfile connectivityProfile, ClusterAccessProfile clusterAccessProfile, ClusterLogAnalyticsProfile logAnalyticsProfile, ClusterPrometheusProfile prometheusProfile, ClusterSshProfile sshProfile, ClusterAutoscaleProfile autoscaleProfile, ClusterRangerPluginProfile rangerPluginProfile, KafkaProfile kafkaProfile, TrinoProfile trinoProfile, IDictionary<string, BinaryData> llapProfile, FlinkProfile flinkProfile, SparkProfile sparkProfile, RangerProfile rangerProfile, IDictionary<string, BinaryData> stubProfile, IList<ScriptActionProfile> scriptActionProfiles, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClusterVersion = clusterVersion;
            OssVersion = ossVersion;
            Components = components;
            IdentityProfile = identityProfile;
            ManagedIdentityProfile = managedIdentityProfile;
            AuthorizationProfile = authorizationProfile;
            SecretsProfile = secretsProfile;
            ServiceConfigsProfiles = serviceConfigsProfiles;
            ConnectivityProfile = connectivityProfile;
            ClusterAccessProfile = clusterAccessProfile;
            LogAnalyticsProfile = logAnalyticsProfile;
            PrometheusProfile = prometheusProfile;
            SshProfile = sshProfile;
            AutoscaleProfile = autoscaleProfile;
            RangerPluginProfile = rangerPluginProfile;
            KafkaProfile = kafkaProfile;
            TrinoProfile = trinoProfile;
            LlapProfile = llapProfile;
            FlinkProfile = flinkProfile;
            SparkProfile = sparkProfile;
            RangerProfile = rangerProfile;
            StubProfile = stubProfile;
            ScriptActionProfiles = scriptActionProfiles;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterProfile"/> for deserialization. </summary>
        internal ClusterProfile()
        {
        }

        /// <summary> Version with 3/4 part. </summary>
        [WirePath("clusterVersion")]
        public string ClusterVersion { get; set; }
        /// <summary> Version with three part. </summary>
        [WirePath("ossVersion")]
        public string OssVersion { get; set; }
        /// <summary> Component list of this cluster type and version. </summary>
        [WirePath("components")]
        public IReadOnlyList<ClusterComponentItem> Components { get; }
        /// <summary> This is deprecated. Please use managed identity profile instead. </summary>
        [WirePath("identityProfile")]
        public HDInsightIdentityProfile IdentityProfile { get; set; }
        /// <summary> This property is required by Trino, Spark and Flink cluster but is optional for Kafka cluster. </summary>
        internal ManagedIdentityProfile ManagedIdentityProfile { get; set; }
        /// <summary> The list of managed identity. </summary>
        [WirePath("managedIdentityProfile.identityList")]
        public IList<HDInsightManagedIdentitySpec> IdentityList
        {
            get => ManagedIdentityProfile is null ? default : ManagedIdentityProfile.IdentityList;
            set => ManagedIdentityProfile = new ManagedIdentityProfile(value);
        }

        /// <summary> Authorization profile with details of AAD user Ids and group Ids authorized for data plane access. </summary>
        [WirePath("authorizationProfile")]
        public AuthorizationProfile AuthorizationProfile { get; set; }
        /// <summary> The cluster secret profile. </summary>
        [WirePath("secretsProfile")]
        public ClusterSecretsProfile SecretsProfile { get; set; }
        /// <summary> The service configs profiles. </summary>
        [WirePath("serviceConfigsProfiles")]
        public IList<ClusterServiceConfigsProfile> ServiceConfigsProfiles { get; }
        /// <summary> Cluster connectivity profile. </summary>
        [WirePath("connectivityProfile")]
        public ClusterConnectivityProfile ConnectivityProfile { get; }
        /// <summary> Cluster access profile. </summary>
        [WirePath("clusterAccessProfile")]
        public ClusterAccessProfile ClusterAccessProfile { get; set; }
        /// <summary> Cluster log analytics profile to enable or disable OMS agent for cluster. </summary>
        [WirePath("logAnalyticsProfile")]
        public ClusterLogAnalyticsProfile LogAnalyticsProfile { get; set; }
        /// <summary> Cluster Prometheus profile. </summary>
        internal ClusterPrometheusProfile PrometheusProfile { get; set; }
        /// <summary> Enable Prometheus for cluster or not. </summary>
        [WirePath("prometheusProfile.enabled")]
        public bool? IsEnabled
        {
            get => PrometheusProfile is null ? default(bool?) : PrometheusProfile.IsEnabled;
            set
            {
                PrometheusProfile = value.HasValue ? new ClusterPrometheusProfile(value.Value) : null;
            }
        }

        /// <summary> Ssh profile for the cluster. </summary>
        [WirePath("sshProfile")]
        public ClusterSshProfile SshProfile { get; set; }
        /// <summary> This is the Autoscale profile for the cluster. This will allow customer to create cluster enabled with Autoscale. </summary>
        [WirePath("autoscaleProfile")]
        public ClusterAutoscaleProfile AutoscaleProfile { get; set; }
        /// <summary> Cluster Ranger plugin profile. </summary>
        internal ClusterRangerPluginProfile RangerPluginProfile { get; set; }
        /// <summary> Enable Ranger for cluster or not. </summary>
        [WirePath("rangerPluginProfile.enabled")]
        public bool? IsRangerForClusterEnabled
        {
            get => RangerPluginProfile is null ? default(bool?) : RangerPluginProfile.IsRangerForClusterEnabled;
            set
            {
                RangerPluginProfile = value.HasValue ? new ClusterRangerPluginProfile(value.Value) : null;
            }
        }

        /// <summary> The Kafka cluster profile. </summary>
        [WirePath("kafkaProfile")]
        public KafkaProfile KafkaProfile { get; set; }
        /// <summary> Trino Cluster profile. </summary>
        [WirePath("trinoProfile")]
        public TrinoProfile TrinoProfile { get; set; }
        /// <summary>
        /// LLAP cluster profile.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("llapProfile")]
        public IDictionary<string, BinaryData> LlapProfile { get; }
        /// <summary> The Flink cluster profile. </summary>
        [WirePath("flinkProfile")]
        public FlinkProfile FlinkProfile { get; set; }
        /// <summary> The spark cluster profile. </summary>
        [WirePath("sparkProfile")]
        public SparkProfile SparkProfile { get; set; }
        /// <summary> The ranger cluster profile. </summary>
        [WirePath("rangerProfile")]
        public RangerProfile RangerProfile { get; set; }
        /// <summary>
        /// Stub cluster profile.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("stubProfile")]
        public IDictionary<string, BinaryData> StubProfile { get; }
        /// <summary> The script action profile list. </summary>
        [WirePath("scriptActionProfiles")]
        public IList<ScriptActionProfile> ScriptActionProfiles { get; }
    }
}
