// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class ClusterProfile : IUtf8JsonSerializable, IJsonModel<ClusterProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClusterProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClusterProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterProfile)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("clusterVersion"u8);
            writer.WriteStringValue(ClusterVersion);
            writer.WritePropertyName("ossVersion"u8);
            writer.WriteStringValue(OssVersion);
            if (options.Format != "W" && Optional.IsCollectionDefined(Components))
            {
                writer.WritePropertyName("components"u8);
                writer.WriteStartArray();
                foreach (var item in Components)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IdentityProfile))
            {
                writer.WritePropertyName("identityProfile"u8);
                writer.WriteObjectValue(IdentityProfile, options);
            }
            if (Optional.IsDefined(ManagedIdentityProfile))
            {
                writer.WritePropertyName("managedIdentityProfile"u8);
                writer.WriteObjectValue(ManagedIdentityProfile, options);
            }
            writer.WritePropertyName("authorizationProfile"u8);
            writer.WriteObjectValue(AuthorizationProfile, options);
            if (Optional.IsDefined(SecretsProfile))
            {
                writer.WritePropertyName("secretsProfile"u8);
                writer.WriteObjectValue(SecretsProfile, options);
            }
            if (Optional.IsCollectionDefined(ServiceConfigsProfiles))
            {
                writer.WritePropertyName("serviceConfigsProfiles"u8);
                writer.WriteStartArray();
                foreach (var item in ServiceConfigsProfiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ConnectivityProfile))
            {
                writer.WritePropertyName("connectivityProfile"u8);
                writer.WriteObjectValue(ConnectivityProfile, options);
            }
            if (Optional.IsDefined(ClusterAccessProfile))
            {
                writer.WritePropertyName("clusterAccessProfile"u8);
                writer.WriteObjectValue(ClusterAccessProfile, options);
            }
            if (Optional.IsDefined(LogAnalyticsProfile))
            {
                writer.WritePropertyName("logAnalyticsProfile"u8);
                writer.WriteObjectValue(LogAnalyticsProfile, options);
            }
            if (Optional.IsDefined(PrometheusProfile))
            {
                writer.WritePropertyName("prometheusProfile"u8);
                writer.WriteObjectValue(PrometheusProfile, options);
            }
            if (Optional.IsDefined(SshProfile))
            {
                writer.WritePropertyName("sshProfile"u8);
                writer.WriteObjectValue(SshProfile, options);
            }
            if (Optional.IsDefined(AutoscaleProfile))
            {
                writer.WritePropertyName("autoscaleProfile"u8);
                writer.WriteObjectValue(AutoscaleProfile, options);
            }
            if (Optional.IsDefined(RangerPluginProfile))
            {
                writer.WritePropertyName("rangerPluginProfile"u8);
                writer.WriteObjectValue(RangerPluginProfile, options);
            }
            if (Optional.IsDefined(KafkaProfile))
            {
                writer.WritePropertyName("kafkaProfile"u8);
                writer.WriteObjectValue(KafkaProfile, options);
            }
            if (Optional.IsDefined(TrinoProfile))
            {
                writer.WritePropertyName("trinoProfile"u8);
                writer.WriteObjectValue(TrinoProfile, options);
            }
            if (Optional.IsCollectionDefined(LlapProfile))
            {
                writer.WritePropertyName("llapProfile"u8);
                writer.WriteStartObject();
                foreach (var item in LlapProfile)
                {
                    writer.WritePropertyName(item.Key);
                    if (item.Value == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(FlinkProfile))
            {
                writer.WritePropertyName("flinkProfile"u8);
                writer.WriteObjectValue(FlinkProfile, options);
            }
            if (Optional.IsDefined(SparkProfile))
            {
                writer.WritePropertyName("sparkProfile"u8);
                writer.WriteObjectValue(SparkProfile, options);
            }
            if (Optional.IsDefined(RangerProfile))
            {
                writer.WritePropertyName("rangerProfile"u8);
                writer.WriteObjectValue(RangerProfile, options);
            }
            if (Optional.IsCollectionDefined(StubProfile))
            {
                writer.WritePropertyName("stubProfile"u8);
                writer.WriteStartObject();
                foreach (var item in StubProfile)
                {
                    writer.WritePropertyName(item.Key);
                    if (item.Value == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(ScriptActionProfiles))
            {
                writer.WritePropertyName("scriptActionProfiles"u8);
                writer.WriteStartArray();
                foreach (var item in ScriptActionProfiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClusterProfile IJsonModel<ClusterProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClusterProfile(document.RootElement, options);
        }

        internal static ClusterProfile DeserializeClusterProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clusterVersion = default;
            string ossVersion = default;
            IReadOnlyList<ClusterComponentItem> components = default;
            HDInsightIdentityProfile identityProfile = default;
            ManagedIdentityProfile managedIdentityProfile = default;
            AuthorizationProfile authorizationProfile = default;
            ClusterSecretsProfile secretsProfile = default;
            IList<ClusterServiceConfigsProfile> serviceConfigsProfiles = default;
            ClusterConnectivityProfile connectivityProfile = default;
            ClusterAccessProfile clusterAccessProfile = default;
            ClusterLogAnalyticsProfile logAnalyticsProfile = default;
            ClusterPrometheusProfile prometheusProfile = default;
            ClusterSshProfile sshProfile = default;
            ClusterAutoscaleProfile autoscaleProfile = default;
            ClusterRangerPluginProfile rangerPluginProfile = default;
            KafkaProfile kafkaProfile = default;
            TrinoProfile trinoProfile = default;
            IDictionary<string, BinaryData> llapProfile = default;
            FlinkProfile flinkProfile = default;
            SparkProfile sparkProfile = default;
            RangerProfile rangerProfile = default;
            IDictionary<string, BinaryData> stubProfile = default;
            IList<ScriptActionProfile> scriptActionProfiles = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clusterVersion"u8))
                {
                    clusterVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ossVersion"u8))
                {
                    ossVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("components"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClusterComponentItem> array = new List<ClusterComponentItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ClusterComponentItem.DeserializeClusterComponentItem(item, options));
                    }
                    components = array;
                    continue;
                }
                if (property.NameEquals("identityProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identityProfile = HDInsightIdentityProfile.DeserializeHDInsightIdentityProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("managedIdentityProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    managedIdentityProfile = ManagedIdentityProfile.DeserializeManagedIdentityProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("authorizationProfile"u8))
                {
                    authorizationProfile = AuthorizationProfile.DeserializeAuthorizationProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("secretsProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secretsProfile = ClusterSecretsProfile.DeserializeClusterSecretsProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("serviceConfigsProfiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClusterServiceConfigsProfile> array = new List<ClusterServiceConfigsProfile>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ClusterServiceConfigsProfile.DeserializeClusterServiceConfigsProfile(item, options));
                    }
                    serviceConfigsProfiles = array;
                    continue;
                }
                if (property.NameEquals("connectivityProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectivityProfile = ClusterConnectivityProfile.DeserializeClusterConnectivityProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("clusterAccessProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clusterAccessProfile = ClusterAccessProfile.DeserializeClusterAccessProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("logAnalyticsProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    logAnalyticsProfile = ClusterLogAnalyticsProfile.DeserializeClusterLogAnalyticsProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("prometheusProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    prometheusProfile = ClusterPrometheusProfile.DeserializeClusterPrometheusProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("sshProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sshProfile = ClusterSshProfile.DeserializeClusterSshProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("autoscaleProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoscaleProfile = ClusterAutoscaleProfile.DeserializeClusterAutoscaleProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("rangerPluginProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rangerPluginProfile = ClusterRangerPluginProfile.DeserializeClusterRangerPluginProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("kafkaProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kafkaProfile = KafkaProfile.DeserializeKafkaProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("trinoProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    trinoProfile = TrinoProfile.DeserializeTrinoProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("llapProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, BinaryData> dictionary = new Dictionary<string, BinaryData>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.Value.ValueKind == JsonValueKind.Null)
                        {
                            dictionary.Add(property0.Name, null);
                        }
                        else
                        {
                            dictionary.Add(property0.Name, BinaryData.FromString(property0.Value.GetRawText()));
                        }
                    }
                    llapProfile = dictionary;
                    continue;
                }
                if (property.NameEquals("flinkProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    flinkProfile = FlinkProfile.DeserializeFlinkProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("sparkProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sparkProfile = SparkProfile.DeserializeSparkProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("rangerProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rangerProfile = RangerProfile.DeserializeRangerProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("stubProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, BinaryData> dictionary = new Dictionary<string, BinaryData>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.Value.ValueKind == JsonValueKind.Null)
                        {
                            dictionary.Add(property0.Name, null);
                        }
                        else
                        {
                            dictionary.Add(property0.Name, BinaryData.FromString(property0.Value.GetRawText()));
                        }
                    }
                    stubProfile = dictionary;
                    continue;
                }
                if (property.NameEquals("scriptActionProfiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ScriptActionProfile> array = new List<ScriptActionProfile>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ScriptActionProfile.DeserializeScriptActionProfile(item, options));
                    }
                    scriptActionProfiles = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClusterProfile(
                clusterVersion,
                ossVersion,
                components ?? new ChangeTrackingList<ClusterComponentItem>(),
                identityProfile,
                managedIdentityProfile,
                authorizationProfile,
                secretsProfile,
                serviceConfigsProfiles ?? new ChangeTrackingList<ClusterServiceConfigsProfile>(),
                connectivityProfile,
                clusterAccessProfile,
                logAnalyticsProfile,
                prometheusProfile,
                sshProfile,
                autoscaleProfile,
                rangerPluginProfile,
                kafkaProfile,
                trinoProfile,
                llapProfile ?? new ChangeTrackingDictionary<string, BinaryData>(),
                flinkProfile,
                sparkProfile,
                rangerProfile,
                stubProfile ?? new ChangeTrackingDictionary<string, BinaryData>(),
                scriptActionProfiles ?? new ChangeTrackingList<ScriptActionProfile>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterVersion))
                {
                    builder.Append("  clusterVersion: ");
                    if (ClusterVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClusterVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClusterVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OssVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  ossVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OssVersion))
                {
                    builder.Append("  ossVersion: ");
                    if (OssVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OssVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OssVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Components), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  components: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Components))
                {
                    if (Components.Any())
                    {
                        builder.Append("  components: ");
                        builder.AppendLine("[");
                        foreach (var item in Components)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  components: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IdentityProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identityProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IdentityProfile))
                {
                    builder.Append("  identityProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, IdentityProfile, options, 2, false, "  identityProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IdentityList", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  managedIdentityProfile: ");
                builder.AppendLine("{");
                builder.Append("    identityList: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(ManagedIdentityProfile))
                {
                    builder.Append("  managedIdentityProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ManagedIdentityProfile, options, 2, false, "  managedIdentityProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthorizationProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authorizationProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthorizationProfile))
                {
                    builder.Append("  authorizationProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AuthorizationProfile, options, 2, false, "  authorizationProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecretsProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  secretsProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecretsProfile))
                {
                    builder.Append("  secretsProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SecretsProfile, options, 2, false, "  secretsProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceConfigsProfiles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serviceConfigsProfiles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ServiceConfigsProfiles))
                {
                    if (ServiceConfigsProfiles.Any())
                    {
                        builder.Append("  serviceConfigsProfiles: ");
                        builder.AppendLine("[");
                        foreach (var item in ServiceConfigsProfiles)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  serviceConfigsProfiles: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConnectivityProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  connectivityProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConnectivityProfile))
                {
                    builder.Append("  connectivityProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ConnectivityProfile, options, 2, false, "  connectivityProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterAccessProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterAccessProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterAccessProfile))
                {
                    builder.Append("  clusterAccessProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ClusterAccessProfile, options, 2, false, "  clusterAccessProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LogAnalyticsProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  logAnalyticsProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LogAnalyticsProfile))
                {
                    builder.Append("  logAnalyticsProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LogAnalyticsProfile, options, 2, false, "  logAnalyticsProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  prometheusProfile: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(PrometheusProfile))
                {
                    builder.Append("  prometheusProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PrometheusProfile, options, 2, false, "  prometheusProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SshProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sshProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SshProfile))
                {
                    builder.Append("  sshProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SshProfile, options, 2, false, "  sshProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AutoscaleProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  autoscaleProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AutoscaleProfile))
                {
                    builder.Append("  autoscaleProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AutoscaleProfile, options, 2, false, "  autoscaleProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsRangerForClusterEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rangerPluginProfile: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(RangerPluginProfile))
                {
                    builder.Append("  rangerPluginProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RangerPluginProfile, options, 2, false, "  rangerPluginProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KafkaProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kafkaProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KafkaProfile))
                {
                    builder.Append("  kafkaProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, KafkaProfile, options, 2, false, "  kafkaProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TrinoProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  trinoProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TrinoProfile))
                {
                    builder.Append("  trinoProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TrinoProfile, options, 2, false, "  trinoProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LlapProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  llapProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(LlapProfile))
                {
                    if (LlapProfile.Any())
                    {
                        builder.Append("  llapProfile: ");
                        builder.AppendLine("{");
                        foreach (var item in LlapProfile)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            builder.AppendLine($"'{item.Value.ToString()}'");
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FlinkProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  flinkProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FlinkProfile))
                {
                    builder.Append("  flinkProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, FlinkProfile, options, 2, false, "  flinkProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SparkProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sparkProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SparkProfile))
                {
                    builder.Append("  sparkProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SparkProfile, options, 2, false, "  sparkProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RangerProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rangerProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RangerProfile))
                {
                    builder.Append("  rangerProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RangerProfile, options, 2, false, "  rangerProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StubProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  stubProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(StubProfile))
                {
                    if (StubProfile.Any())
                    {
                        builder.Append("  stubProfile: ");
                        builder.AppendLine("{");
                        foreach (var item in StubProfile)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            builder.AppendLine($"'{item.Value.ToString()}'");
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScriptActionProfiles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  scriptActionProfiles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ScriptActionProfiles))
                {
                    if (ScriptActionProfiles.Any())
                    {
                        builder.Append("  scriptActionProfiles: ");
                        builder.AppendLine("[");
                        foreach (var item in ScriptActionProfiles)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  scriptActionProfiles: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ClusterProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ClusterProfile)} does not support writing '{options.Format}' format.");
            }
        }

        ClusterProfile IPersistableModel<ClusterProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClusterProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClusterProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClusterProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
