// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster pool version properties. </summary>
    public partial class ClusterPoolVersionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterPoolVersionProperties"/>. </summary>
        public ClusterPoolVersionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolVersionProperties"/>. </summary>
        /// <param name="clusterPoolVersion"> Cluster pool version is a 2-part version. </param>
        /// <param name="aksVersion"> AKS version. </param>
        /// <param name="isPreview"> Indicate if this version is in preview or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterPoolVersionProperties(string clusterPoolVersion, string aksVersion, bool? isPreview, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClusterPoolVersion = clusterPoolVersion;
            AksVersion = aksVersion;
            IsPreview = isPreview;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Cluster pool version is a 2-part version. </summary>
        [WirePath("clusterPoolVersion")]
        public string ClusterPoolVersion { get; set; }
        /// <summary> AKS version. </summary>
        [WirePath("aksVersion")]
        public string AksVersion { get; set; }
        /// <summary> Indicate if this version is in preview or not. </summary>
        [WirePath("isPreview")]
        public bool? IsPreview { get; set; }
    }
}
