// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Type of upgrade. </summary>
    internal readonly partial struct ClusterPoolUpgradeType : IEquatable<ClusterPoolUpgradeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterPoolUpgradeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterPoolUpgradeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AKSPatchUpgradeValue = "AKSPatchUpgrade";
        private const string NodeOSUpgradeValue = "NodeOsUpgrade";

        /// <summary> AKSPatchUpgrade. </summary>
        public static ClusterPoolUpgradeType AKSPatchUpgrade { get; } = new ClusterPoolUpgradeType(AKSPatchUpgradeValue);
        /// <summary> NodeOsUpgrade. </summary>
        public static ClusterPoolUpgradeType NodeOSUpgrade { get; } = new ClusterPoolUpgradeType(NodeOSUpgradeValue);
        /// <summary> Determines if two <see cref="ClusterPoolUpgradeType"/> values are the same. </summary>
        public static bool operator ==(ClusterPoolUpgradeType left, ClusterPoolUpgradeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterPoolUpgradeType"/> values are not the same. </summary>
        public static bool operator !=(ClusterPoolUpgradeType left, ClusterPoolUpgradeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterPoolUpgradeType"/>. </summary>
        public static implicit operator ClusterPoolUpgradeType(string value) => new ClusterPoolUpgradeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterPoolUpgradeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterPoolUpgradeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
