// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Type of upgrade. </summary>
    internal readonly partial struct ClusterPoolUpgradeHistoryType : IEquatable<ClusterPoolUpgradeHistoryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterPoolUpgradeHistoryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterPoolUpgradeHistoryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AKSPatchUpgradeValue = "AKSPatchUpgrade";
        private const string NodeOSUpgradeValue = "NodeOsUpgrade";

        /// <summary> AKSPatchUpgrade. </summary>
        public static ClusterPoolUpgradeHistoryType AKSPatchUpgrade { get; } = new ClusterPoolUpgradeHistoryType(AKSPatchUpgradeValue);
        /// <summary> NodeOsUpgrade. </summary>
        public static ClusterPoolUpgradeHistoryType NodeOSUpgrade { get; } = new ClusterPoolUpgradeHistoryType(NodeOSUpgradeValue);
        /// <summary> Determines if two <see cref="ClusterPoolUpgradeHistoryType"/> values are the same. </summary>
        public static bool operator ==(ClusterPoolUpgradeHistoryType left, ClusterPoolUpgradeHistoryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterPoolUpgradeHistoryType"/> values are not the same. </summary>
        public static bool operator !=(ClusterPoolUpgradeHistoryType left, ClusterPoolUpgradeHistoryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterPoolUpgradeHistoryType"/>. </summary>
        public static implicit operator ClusterPoolUpgradeHistoryType(string value) => new ClusterPoolUpgradeHistoryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterPoolUpgradeHistoryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterPoolUpgradeHistoryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
