// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster Pool Upgrade. </summary>
    public partial class ClusterPoolUpgrade
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterPoolUpgrade"/>. </summary>
        /// <param name="properties">
        /// Properties of upgrading cluster pool.
        /// Please note <see cref="ClusterPoolUpgradeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClusterPoolAKSPatchVersionUpgradeProperties"/> and <see cref="ClusterPoolNodeOSImageUpdateProperties"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public ClusterPoolUpgrade(ClusterPoolUpgradeProperties properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolUpgrade"/>. </summary>
        /// <param name="properties">
        /// Properties of upgrading cluster pool.
        /// Please note <see cref="ClusterPoolUpgradeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClusterPoolAKSPatchVersionUpgradeProperties"/> and <see cref="ClusterPoolNodeOSImageUpdateProperties"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterPoolUpgrade(ClusterPoolUpgradeProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolUpgrade"/> for deserialization. </summary>
        internal ClusterPoolUpgrade()
        {
        }

        /// <summary>
        /// Properties of upgrading cluster pool.
        /// Please note <see cref="ClusterPoolUpgradeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ClusterPoolAKSPatchVersionUpgradeProperties"/> and <see cref="ClusterPoolNodeOSImageUpdateProperties"/>.
        /// </summary>
        [WirePath("properties")]
        public ClusterPoolUpgradeProperties Properties { get; }
    }
}
