// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster pool node os upgrade history properties. </summary>
    public partial class ClusterPoolNodeOSUpgradeHistoryProperties : ClusterPoolUpgradeHistoryProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterPoolNodeOSUpgradeHistoryProperties"/>. </summary>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="utcTime"/> is null. </exception>
        public ClusterPoolNodeOSUpgradeHistoryProperties(string utcTime, ClusterPoolUpgradeHistoryUpgradeResultType upgradeResult) : base(utcTime, upgradeResult)
        {
            Argument.AssertNotNull(utcTime, nameof(utcTime));

            UpgradeType = ClusterPoolUpgradeHistoryType.NodeOSUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolNodeOSUpgradeHistoryProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="newNodeOS"> New Node Os version. </param>
        internal ClusterPoolNodeOSUpgradeHistoryProperties(ClusterPoolUpgradeHistoryType upgradeType, string utcTime, ClusterPoolUpgradeHistoryUpgradeResultType upgradeResult, IDictionary<string, BinaryData> serializedAdditionalRawData, string newNodeOS) : base(upgradeType, utcTime, upgradeResult, serializedAdditionalRawData)
        {
            NewNodeOS = newNodeOS;
            UpgradeType = upgradeType;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolNodeOSUpgradeHistoryProperties"/> for deserialization. </summary>
        internal ClusterPoolNodeOSUpgradeHistoryProperties()
        {
        }

        /// <summary> New Node Os version. </summary>
        [WirePath("newNodeOs")]
        public string NewNodeOS { get; set; }
    }
}
