// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster pool networking configuration. </summary>
    public partial class ClusterPoolNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterPoolNetworkProfile"/>. </summary>
        /// <param name="subnetId"> Cluster pool subnet resource id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subnetId"/> is null. </exception>
        public ClusterPoolNetworkProfile(ResourceIdentifier subnetId)
        {
            Argument.AssertNotNull(subnetId, nameof(subnetId));

            SubnetId = subnetId;
            ApiServerAuthorizedIPRanges = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolNetworkProfile"/>. </summary>
        /// <param name="subnetId"> Cluster pool subnet resource id. </param>
        /// <param name="outboundType"> This can only be set at cluster pool creation time and cannot be changed later. </param>
        /// <param name="isPrivateApiServerEnabled"> ClusterPool is based on AKS cluster. AKS cluster exposes the API server to public internet by default. If you set this property to true, a private AKS cluster will be created, and it will use private apiserver, which is not exposed to public internet. </param>
        /// <param name="apiServerAuthorizedIPRanges"> IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with private AKS clusters. So you cannot set enablePrivateApiServer to true and apiServerAuthorizedIpRanges at the same time. Currently, this property is not supported and please don't use it. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterPoolNetworkProfile(ResourceIdentifier subnetId, OutboundType? outboundType, bool? isPrivateApiServerEnabled, IList<string> apiServerAuthorizedIPRanges, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SubnetId = subnetId;
            OutboundType = outboundType;
            IsPrivateApiServerEnabled = isPrivateApiServerEnabled;
            ApiServerAuthorizedIPRanges = apiServerAuthorizedIPRanges;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolNetworkProfile"/> for deserialization. </summary>
        internal ClusterPoolNetworkProfile()
        {
        }

        /// <summary> Cluster pool subnet resource id. </summary>
        [WirePath("subnetId")]
        public ResourceIdentifier SubnetId { get; set; }
        /// <summary> This can only be set at cluster pool creation time and cannot be changed later. </summary>
        [WirePath("outboundType")]
        public OutboundType? OutboundType { get; set; }
        /// <summary> ClusterPool is based on AKS cluster. AKS cluster exposes the API server to public internet by default. If you set this property to true, a private AKS cluster will be created, and it will use private apiserver, which is not exposed to public internet. </summary>
        [WirePath("enablePrivateApiServer")]
        public bool? IsPrivateApiServerEnabled { get; set; }
        /// <summary> IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with private AKS clusters. So you cannot set enablePrivateApiServer to true and apiServerAuthorizedIpRanges at the same time. Currently, this property is not supported and please don't use it. </summary>
        [WirePath("apiServerAuthorizedIpRanges")]
        public IList<string> ApiServerAuthorizedIPRanges { get; }
    }
}
