// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Type of upgrade. </summary>
    internal readonly partial struct ClusterPoolAvailableUpgradeType : IEquatable<ClusterPoolAvailableUpgradeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterPoolAvailableUpgradeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterPoolAvailableUpgradeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AKSPatchUpgradeValue = "AKSPatchUpgrade";
        private const string NodeOSUpgradeValue = "NodeOsUpgrade";

        /// <summary> AKSPatchUpgrade. </summary>
        public static ClusterPoolAvailableUpgradeType AKSPatchUpgrade { get; } = new ClusterPoolAvailableUpgradeType(AKSPatchUpgradeValue);
        /// <summary> NodeOsUpgrade. </summary>
        public static ClusterPoolAvailableUpgradeType NodeOSUpgrade { get; } = new ClusterPoolAvailableUpgradeType(NodeOSUpgradeValue);
        /// <summary> Determines if two <see cref="ClusterPoolAvailableUpgradeType"/> values are the same. </summary>
        public static bool operator ==(ClusterPoolAvailableUpgradeType left, ClusterPoolAvailableUpgradeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterPoolAvailableUpgradeType"/> values are not the same. </summary>
        public static bool operator !=(ClusterPoolAvailableUpgradeType left, ClusterPoolAvailableUpgradeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterPoolAvailableUpgradeType"/>. </summary>
        public static implicit operator ClusterPoolAvailableUpgradeType(string value) => new ClusterPoolAvailableUpgradeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterPoolAvailableUpgradeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterPoolAvailableUpgradeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
