// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster pool available node OS update. </summary>
    public partial class ClusterPoolAvailableUpgradeNodeOSUpgradeProperties : ClusterPoolAvailableUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterPoolAvailableUpgradeNodeOSUpgradeProperties"/>. </summary>
        public ClusterPoolAvailableUpgradeNodeOSUpgradeProperties()
        {
            UpgradeType = ClusterPoolAvailableUpgradeType.NodeOSUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolAvailableUpgradeNodeOSUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="latestVersion"> The latest node OS version. </param>
        internal ClusterPoolAvailableUpgradeNodeOSUpgradeProperties(ClusterPoolAvailableUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string latestVersion) : base(upgradeType, serializedAdditionalRawData)
        {
            LatestVersion = latestVersion;
            UpgradeType = upgradeType;
        }

        /// <summary> The latest node OS version. </summary>
        [WirePath("latestVersion")]
        public string LatestVersion { get; set; }
    }
}
