// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster pool available AKS patch version upgrade. </summary>
    public partial class ClusterPoolAvailableUpgradeAksPatchUpgradeProperties : ClusterPoolAvailableUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterPoolAvailableUpgradeAksPatchUpgradeProperties"/>. </summary>
        public ClusterPoolAvailableUpgradeAksPatchUpgradeProperties()
        {
            UpgradeType = ClusterPoolAvailableUpgradeType.AKSPatchUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolAvailableUpgradeAksPatchUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="currentVersion"> Current AKS version. </param>
        /// <param name="currentVersionStatus"> Current AKS version's status: whether it is deprecated or supported. </param>
        /// <param name="latestVersion"> Latest AKS patch version. </param>
        internal ClusterPoolAvailableUpgradeAksPatchUpgradeProperties(ClusterPoolAvailableUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string currentVersion, CurrentClusterPoolAksVersionStatus? currentVersionStatus, string latestVersion) : base(upgradeType, serializedAdditionalRawData)
        {
            CurrentVersion = currentVersion;
            CurrentVersionStatus = currentVersionStatus;
            LatestVersion = latestVersion;
            UpgradeType = upgradeType;
        }

        /// <summary> Current AKS version. </summary>
        [WirePath("currentVersion")]
        public string CurrentVersion { get; set; }
        /// <summary> Current AKS version's status: whether it is deprecated or supported. </summary>
        [WirePath("currentVersionStatus")]
        public CurrentClusterPoolAksVersionStatus? CurrentVersionStatus { get; set; }
        /// <summary> Latest AKS patch version. </summary>
        [WirePath("latestVersion")]
        public string LatestVersion { get; set; }
    }
}
