// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster pool aks upgrade history properties. </summary>
    public partial class ClusterPoolAksPatchUpgradeHistoryProperties : ClusterPoolUpgradeHistoryProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterPoolAksPatchUpgradeHistoryProperties"/>. </summary>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="utcTime"/> is null. </exception>
        public ClusterPoolAksPatchUpgradeHistoryProperties(string utcTime, ClusterPoolUpgradeHistoryUpgradeResultType upgradeResult) : base(utcTime, upgradeResult)
        {
            Argument.AssertNotNull(utcTime, nameof(utcTime));

            UpgradeType = ClusterPoolUpgradeHistoryType.AKSPatchUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolAksPatchUpgradeHistoryProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="upgradeClusterPool"> Whether upgrade cluster pool. </param>
        /// <param name="upgradeAllClusterNodes"> Whether upgrade all cluster nodes. </param>
        /// <param name="originalVersion"> Version before update. </param>
        /// <param name="newVersion"> Version going to update. </param>
        internal ClusterPoolAksPatchUpgradeHistoryProperties(ClusterPoolUpgradeHistoryType upgradeType, string utcTime, ClusterPoolUpgradeHistoryUpgradeResultType upgradeResult, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? upgradeClusterPool, bool? upgradeAllClusterNodes, string originalVersion, string newVersion) : base(upgradeType, utcTime, upgradeResult, serializedAdditionalRawData)
        {
            UpgradeClusterPool = upgradeClusterPool;
            UpgradeAllClusterNodes = upgradeAllClusterNodes;
            OriginalVersion = originalVersion;
            NewVersion = newVersion;
            UpgradeType = upgradeType;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolAksPatchUpgradeHistoryProperties"/> for deserialization. </summary>
        internal ClusterPoolAksPatchUpgradeHistoryProperties()
        {
        }

        /// <summary> Whether upgrade cluster pool. </summary>
        [WirePath("upgradeClusterPool")]
        public bool? UpgradeClusterPool { get; set; }
        /// <summary> Whether upgrade all cluster nodes. </summary>
        [WirePath("upgradeAllClusterNodes")]
        public bool? UpgradeAllClusterNodes { get; set; }
        /// <summary> Version before update. </summary>
        [WirePath("originalVersion")]
        public string OriginalVersion { get; set; }
        /// <summary> Version going to update. </summary>
        [WirePath("newVersion")]
        public string NewVersion { get; set; }
    }
}
