// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties of upgrading cluster pool's AKS patch version. </summary>
    public partial class ClusterPoolAKSPatchVersionUpgradeProperties : ClusterPoolUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterPoolAKSPatchVersionUpgradeProperties"/>. </summary>
        public ClusterPoolAKSPatchVersionUpgradeProperties()
        {
            UpgradeType = ClusterPoolUpgradeType.AKSPatchUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPoolAKSPatchVersionUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="upgradeClusterPool"> whether upgrade cluster pool or not. If it's true, upgradeAllClusterNodes should be false. </param>
        /// <param name="upgradeAllClusterNodes"> whether upgrade all clusters' nodes. If it's true, upgradeClusterPool should be false. </param>
        /// <param name="targetAksVersion"> Target AKS version. When it's not set, latest version will be used. When upgradeClusterPool is true and upgradeAllClusterNodes is false, target version should be greater or equal to current version. When upgradeClusterPool is false and upgradeAllClusterNodes is true, target version should be equal to AKS version of cluster pool. </param>
        internal ClusterPoolAKSPatchVersionUpgradeProperties(ClusterPoolUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? upgradeClusterPool, bool? upgradeAllClusterNodes, string targetAksVersion) : base(upgradeType, serializedAdditionalRawData)
        {
            UpgradeClusterPool = upgradeClusterPool;
            UpgradeAllClusterNodes = upgradeAllClusterNodes;
            TargetAksVersion = targetAksVersion;
            UpgradeType = upgradeType;
        }

        /// <summary> whether upgrade cluster pool or not. If it's true, upgradeAllClusterNodes should be false. </summary>
        [WirePath("upgradeClusterPool")]
        public bool? UpgradeClusterPool { get; set; }
        /// <summary> whether upgrade all clusters' nodes. If it's true, upgradeClusterPool should be false. </summary>
        [WirePath("upgradeAllClusterNodes")]
        public bool? UpgradeAllClusterNodes { get; set; }
        /// <summary> Target AKS version. When it's not set, latest version will be used. When upgradeClusterPool is true and upgradeAllClusterNodes is false, target version should be greater or equal to current version. When upgradeClusterPool is false and upgradeAllClusterNodes is true, target version should be equal to AKS version of cluster pool. </summary>
        [WirePath("targetAksVersion")]
        public string TargetAksVersion { get; set; }
    }
}
