// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class ClusterPoolAKSPatchVersionUpgradeProperties : IUtf8JsonSerializable, IJsonModel<ClusterPoolAKSPatchVersionUpgradeProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClusterPoolAKSPatchVersionUpgradeProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClusterPoolAKSPatchVersionUpgradeProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterPoolAKSPatchVersionUpgradeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterPoolAKSPatchVersionUpgradeProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(UpgradeClusterPool))
            {
                writer.WritePropertyName("upgradeClusterPool"u8);
                writer.WriteBooleanValue(UpgradeClusterPool.Value);
            }
            if (Optional.IsDefined(UpgradeAllClusterNodes))
            {
                writer.WritePropertyName("upgradeAllClusterNodes"u8);
                writer.WriteBooleanValue(UpgradeAllClusterNodes.Value);
            }
            if (Optional.IsDefined(TargetAksVersion))
            {
                writer.WritePropertyName("targetAksVersion"u8);
                writer.WriteStringValue(TargetAksVersion);
            }
        }

        ClusterPoolAKSPatchVersionUpgradeProperties IJsonModel<ClusterPoolAKSPatchVersionUpgradeProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterPoolAKSPatchVersionUpgradeProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterPoolAKSPatchVersionUpgradeProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClusterPoolAKSPatchVersionUpgradeProperties(document.RootElement, options);
        }

        internal static ClusterPoolAKSPatchVersionUpgradeProperties DeserializeClusterPoolAKSPatchVersionUpgradeProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? upgradeClusterPool = default;
            bool? upgradeAllClusterNodes = default;
            string targetAksVersion = default;
            ClusterPoolUpgradeType upgradeType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("upgradeClusterPool"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    upgradeClusterPool = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("upgradeAllClusterNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    upgradeAllClusterNodes = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("targetAksVersion"u8))
                {
                    targetAksVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("upgradeType"u8))
                {
                    upgradeType = new ClusterPoolUpgradeType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClusterPoolAKSPatchVersionUpgradeProperties(upgradeType, serializedAdditionalRawData, upgradeClusterPool, upgradeAllClusterNodes, targetAksVersion);
        }

        BinaryData IPersistableModel<ClusterPoolAKSPatchVersionUpgradeProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterPoolAKSPatchVersionUpgradeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ClusterPoolAKSPatchVersionUpgradeProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ClusterPoolAKSPatchVersionUpgradeProperties IPersistableModel<ClusterPoolAKSPatchVersionUpgradeProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterPoolAKSPatchVersionUpgradeProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClusterPoolAKSPatchVersionUpgradeProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClusterPoolAKSPatchVersionUpgradeProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClusterPoolAKSPatchVersionUpgradeProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
