// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties of upgrading cluster's patch version. </summary>
    public partial class ClusterPatchVersionUpgradeProperties : ClusterInPlaceUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterPatchVersionUpgradeProperties"/>. </summary>
        public ClusterPatchVersionUpgradeProperties()
        {
            UpgradeType = ClusterUpgradeType.PatchVersionUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterPatchVersionUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="targetOssVersion"> Target OSS version of component to be upgraded. </param>
        /// <param name="targetClusterVersion"> Target cluster version of component to be upgraded. </param>
        /// <param name="targetBuildNumber"> Target build number of component to be upgraded. </param>
        /// <param name="componentName"> Name of component to be upgraded. </param>
        internal ClusterPatchVersionUpgradeProperties(ClusterUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string targetOssVersion, string targetClusterVersion, string targetBuildNumber, string componentName) : base(upgradeType, serializedAdditionalRawData, targetOssVersion, targetClusterVersion, targetBuildNumber, componentName)
        {
            UpgradeType = upgradeType;
        }
    }
}
