// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster log analytics profile to enable or disable OMS agent for cluster. </summary>
    public partial class ClusterLogAnalyticsProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterLogAnalyticsProfile"/>. </summary>
        /// <param name="isEnabled"> True if log analytics is enabled for the cluster, otherwise false. </param>
        public ClusterLogAnalyticsProfile(bool isEnabled)
        {
            IsEnabled = isEnabled;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterLogAnalyticsProfile"/>. </summary>
        /// <param name="isEnabled"> True if log analytics is enabled for the cluster, otherwise false. </param>
        /// <param name="applicationLogs"> Collection of logs to be enabled or disabled for log analytics. </param>
        /// <param name="isMetricsEnabled"> True if metrics are enabled, otherwise false. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterLogAnalyticsProfile(bool isEnabled, ClusterLogAnalyticsApplicationLogs applicationLogs, bool? isMetricsEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            ApplicationLogs = applicationLogs;
            IsMetricsEnabled = isMetricsEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterLogAnalyticsProfile"/> for deserialization. </summary>
        internal ClusterLogAnalyticsProfile()
        {
        }

        /// <summary> True if log analytics is enabled for the cluster, otherwise false. </summary>
        [WirePath("enabled")]
        public bool IsEnabled { get; set; }
        /// <summary> Collection of logs to be enabled or disabled for log analytics. </summary>
        [WirePath("applicationLogs")]
        public ClusterLogAnalyticsApplicationLogs ApplicationLogs { get; set; }
        /// <summary> True if metrics are enabled, otherwise false. </summary>
        [WirePath("metricsEnabled")]
        public bool? IsMetricsEnabled { get; set; }
    }
}
