// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Collection of logs to be enabled or disabled for log analytics. </summary>
    public partial class ClusterLogAnalyticsApplicationLogs
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterLogAnalyticsApplicationLogs"/>. </summary>
        public ClusterLogAnalyticsApplicationLogs()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterLogAnalyticsApplicationLogs"/>. </summary>
        /// <param name="isStdOutEnabled"> True if stdout is enabled, otherwise false. </param>
        /// <param name="isStdErrorEnabled"> True if stderror is enabled, otherwise false. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterLogAnalyticsApplicationLogs(bool? isStdOutEnabled, bool? isStdErrorEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsStdOutEnabled = isStdOutEnabled;
            IsStdErrorEnabled = isStdErrorEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> True if stdout is enabled, otherwise false. </summary>
        [WirePath("stdOutEnabled")]
        public bool? IsStdOutEnabled { get; set; }
        /// <summary> True if stderror is enabled, otherwise false. </summary>
        [WirePath("stdErrorEnabled")]
        public bool? IsStdErrorEnabled { get; set; }
    }
}
