// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary>
    /// Properties of a library in the cluster.
    /// Please note <see cref="ClusterLibraryProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ClusterMavenLibraryProperties"/> and <see cref="ClusterPyPILibraryProperties"/>.
    /// </summary>
    public abstract partial class ClusterLibraryProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterLibraryProperties"/>. </summary>
        protected ClusterLibraryProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterLibraryProperties"/>. </summary>
        /// <param name="libraryType"> Type of the library. </param>
        /// <param name="remarks"> Remark of the latest library management operation. </param>
        /// <param name="timestamp"> Timestamp of the latest library management operation. </param>
        /// <param name="status"> Status of the library. </param>
        /// <param name="message"> Error message of the library operation when a failure occurs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterLibraryProperties(Type libraryType, string remarks, DateTimeOffset? timestamp, Status? status, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LibraryType = libraryType;
            Remarks = remarks;
            Timestamp = timestamp;
            Status = status;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of the library. </summary>
        internal Type LibraryType { get; set; }
        /// <summary> Remark of the latest library management operation. </summary>
        [WirePath("remarks")]
        public string Remarks { get; set; }
        /// <summary> Timestamp of the latest library management operation. </summary>
        [WirePath("timestamp")]
        public DateTimeOffset? Timestamp { get; }
        /// <summary> Status of the library. </summary>
        [WirePath("status")]
        public Status? Status { get; }
        /// <summary> Error message of the library operation when a failure occurs. </summary>
        [WirePath("message")]
        public string Message { get; }
    }
}
