// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Properties of a library management operation. </summary>
    public partial class ClusterLibraryManagementOperationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterLibraryManagementOperationProperties"/>. </summary>
        /// <param name="action"> The library management action. </param>
        /// <param name="libraries"> The libraries to be installed/updated/uninstalled. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="libraries"/> is null. </exception>
        public ClusterLibraryManagementOperationProperties(LibraryManagementAction action, IEnumerable<ClusterLibrary> libraries)
        {
            Argument.AssertNotNull(libraries, nameof(libraries));

            Action = action;
            Libraries = libraries.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterLibraryManagementOperationProperties"/>. </summary>
        /// <param name="action"> The library management action. </param>
        /// <param name="libraries"> The libraries to be installed/updated/uninstalled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterLibraryManagementOperationProperties(LibraryManagementAction action, IList<ClusterLibrary> libraries, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Action = action;
            Libraries = libraries;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterLibraryManagementOperationProperties"/> for deserialization. </summary>
        internal ClusterLibraryManagementOperationProperties()
        {
        }

        /// <summary> The library management action. </summary>
        [WirePath("action")]
        public LibraryManagementAction Action { get; set; }
        /// <summary> The libraries to be installed/updated/uninstalled. </summary>
        [WirePath("libraries")]
        public IList<ClusterLibrary> Libraries { get; }
    }
}
