// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The ClusterLibraryCategory. </summary>
    public readonly partial struct ClusterLibraryCategory : IEquatable<ClusterLibraryCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterLibraryCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterLibraryCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomValue = "custom";
        private const string PredefinedValue = "predefined";

        /// <summary> custom. </summary>
        public static ClusterLibraryCategory Custom { get; } = new ClusterLibraryCategory(CustomValue);
        /// <summary> predefined. </summary>
        public static ClusterLibraryCategory Predefined { get; } = new ClusterLibraryCategory(PredefinedValue);
        /// <summary> Determines if two <see cref="ClusterLibraryCategory"/> values are the same. </summary>
        public static bool operator ==(ClusterLibraryCategory left, ClusterLibraryCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterLibraryCategory"/> values are not the same. </summary>
        public static bool operator !=(ClusterLibraryCategory left, ClusterLibraryCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterLibraryCategory"/>. </summary>
        public static implicit operator ClusterLibraryCategory(string value) => new ClusterLibraryCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterLibraryCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterLibraryCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
