// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Status of the instance view. </summary>
    public partial class ClusterInstanceViewStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterInstanceViewStatus"/>. </summary>
        /// <param name="ready"> The cluster ready status. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ready"/> is null. </exception>
        internal ClusterInstanceViewStatus(string ready)
        {
            Argument.AssertNotNull(ready, nameof(ready));

            Ready = ready;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterInstanceViewStatus"/>. </summary>
        /// <param name="ready"> The cluster ready status. </param>
        /// <param name="reason"> The status reason. </param>
        /// <param name="message"> The additional message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterInstanceViewStatus(string ready, string reason, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ready = ready;
            Reason = reason;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterInstanceViewStatus"/> for deserialization. </summary>
        internal ClusterInstanceViewStatus()
        {
        }

        /// <summary> The cluster ready status. </summary>
        [WirePath("ready")]
        public string Ready { get; }
        /// <summary> The status reason. </summary>
        [WirePath("reason")]
        public string Reason { get; }
        /// <summary> The additional message. </summary>
        [WirePath("message")]
        public string Message { get; }
    }
}
