// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    public partial class ClusterInstanceViewProperties : IUtf8JsonSerializable, IJsonModel<ClusterInstanceViewProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClusterInstanceViewProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClusterInstanceViewProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterInstanceViewProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterInstanceViewProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("status"u8);
            writer.WriteObjectValue(Status, options);
            writer.WritePropertyName("serviceStatuses"u8);
            writer.WriteStartArray();
            foreach (var item in ServiceStatuses)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClusterInstanceViewProperties IJsonModel<ClusterInstanceViewProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterInstanceViewProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterInstanceViewProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClusterInstanceViewProperties(document.RootElement, options);
        }

        internal static ClusterInstanceViewProperties DeserializeClusterInstanceViewProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ClusterInstanceViewStatus status = default;
            IReadOnlyList<HDInsightServiceStatus> serviceStatuses = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("status"u8))
                {
                    status = ClusterInstanceViewStatus.DeserializeClusterInstanceViewStatus(property.Value, options);
                    continue;
                }
                if (property.NameEquals("serviceStatuses"u8))
                {
                    List<HDInsightServiceStatus> array = new List<HDInsightServiceStatus>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HDInsightServiceStatus.DeserializeHDInsightServiceStatus(item, options));
                    }
                    serviceStatuses = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClusterInstanceViewProperties(status, serviceStatuses, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("  status: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Status, options, 2, false, "  status: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceStatuses), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serviceStatuses: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ServiceStatuses))
                {
                    if (ServiceStatuses.Any())
                    {
                        builder.Append("  serviceStatuses: ");
                        builder.AppendLine("[");
                        foreach (var item in ServiceStatuses)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  serviceStatuses: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ClusterInstanceViewProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterInstanceViewProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ClusterInstanceViewProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ClusterInstanceViewProperties IPersistableModel<ClusterInstanceViewProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterInstanceViewProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClusterInstanceViewProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClusterInstanceViewProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClusterInstanceViewProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
