// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary>
    /// Properties of in-place upgrading cluster.
    /// Please note <see cref="ClusterInPlaceUpgradeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ClusterHotfixUpgradeProperties"/> and <see cref="ClusterPatchVersionUpgradeProperties"/>.
    /// </summary>
    public partial class ClusterInPlaceUpgradeProperties : ClusterUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterInPlaceUpgradeProperties"/>. </summary>
        public ClusterInPlaceUpgradeProperties()
        {
            UpgradeType = new ClusterUpgradeType("ClusterInPlaceUpgradeProperties");
        }

        /// <summary> Initializes a new instance of <see cref="ClusterInPlaceUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="targetOssVersion"> Target OSS version of component to be upgraded. </param>
        /// <param name="targetClusterVersion"> Target cluster version of component to be upgraded. </param>
        /// <param name="targetBuildNumber"> Target build number of component to be upgraded. </param>
        /// <param name="componentName"> Name of component to be upgraded. </param>
        internal ClusterInPlaceUpgradeProperties(ClusterUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string targetOssVersion, string targetClusterVersion, string targetBuildNumber, string componentName) : base(upgradeType, serializedAdditionalRawData)
        {
            TargetOssVersion = targetOssVersion;
            TargetClusterVersion = targetClusterVersion;
            TargetBuildNumber = targetBuildNumber;
            ComponentName = componentName;
            UpgradeType = upgradeType;
        }

        /// <summary> Target OSS version of component to be upgraded. </summary>
        [WirePath("targetOssVersion")]
        public string TargetOssVersion { get; set; }
        /// <summary> Target cluster version of component to be upgraded. </summary>
        [WirePath("targetClusterVersion")]
        public string TargetClusterVersion { get; set; }
        /// <summary> Target build number of component to be upgraded. </summary>
        [WirePath("targetBuildNumber")]
        public string TargetBuildNumber { get; set; }
        /// <summary> Name of component to be upgraded. </summary>
        [WirePath("componentName")]
        public string ComponentName { get; set; }
    }
}
