// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary>
    /// Cluster in-place upgrade history properties.
    /// Please note <see cref="ClusterInPlaceUpgradeHistoryProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ClusterHotfixUpgradeHistoryProperties"/>, <see cref="ClusterHotfixUpgradeRollbackHistoryProperties"/>, <see cref="ClusterPatchVersionUpgradeHistoryProperties"/> and <see cref="ClusterPatchVersionUpgradeRollbackHistoryProperties"/>.
    /// </summary>
    public partial class ClusterInPlaceUpgradeHistoryProperties : ClusterUpgradeHistoryProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterInPlaceUpgradeHistoryProperties"/>. </summary>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="utcTime"/> is null. </exception>
        public ClusterInPlaceUpgradeHistoryProperties(string utcTime, ClusterUpgradeHistoryUpgradeResultType upgradeResult) : base(utcTime, upgradeResult)
        {
            Argument.AssertNotNull(utcTime, nameof(utcTime));

            UpgradeType = new ClusterUpgradeHistoryType("ClusterInPlaceUpgradeHistoryProperties");
        }

        /// <summary> Initializes a new instance of <see cref="ClusterInPlaceUpgradeHistoryProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="utcTime"> Time when created this upgrade history. </param>
        /// <param name="upgradeResult"> Result of this upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="sourceClusterVersion"> Version with three part. </param>
        /// <param name="sourceOssVersion"> Version with three part. </param>
        /// <param name="sourceBuildNumber"> Source build number. </param>
        /// <param name="targetClusterVersion"> Version with three part. </param>
        /// <param name="targetOssVersion"> Version with three part. </param>
        /// <param name="targetBuildNumber"> Target build number. </param>
        /// <param name="componentName"> Component name to upgrade. </param>
        /// <param name="severity"> Severity of this upgrade. </param>
        internal ClusterInPlaceUpgradeHistoryProperties(ClusterUpgradeHistoryType upgradeType, string utcTime, ClusterUpgradeHistoryUpgradeResultType upgradeResult, IDictionary<string, BinaryData> serializedAdditionalRawData, string sourceClusterVersion, string sourceOssVersion, string sourceBuildNumber, string targetClusterVersion, string targetOssVersion, string targetBuildNumber, string componentName, ClusterUpgradeHistorySeverityType? severity) : base(upgradeType, utcTime, upgradeResult, serializedAdditionalRawData)
        {
            SourceClusterVersion = sourceClusterVersion;
            SourceOssVersion = sourceOssVersion;
            SourceBuildNumber = sourceBuildNumber;
            TargetClusterVersion = targetClusterVersion;
            TargetOssVersion = targetOssVersion;
            TargetBuildNumber = targetBuildNumber;
            ComponentName = componentName;
            Severity = severity;
            UpgradeType = upgradeType;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterInPlaceUpgradeHistoryProperties"/> for deserialization. </summary>
        internal ClusterInPlaceUpgradeHistoryProperties()
        {
        }

        /// <summary> Version with three part. </summary>
        [WirePath("sourceClusterVersion")]
        public string SourceClusterVersion { get; set; }
        /// <summary> Version with three part. </summary>
        [WirePath("sourceOssVersion")]
        public string SourceOssVersion { get; set; }
        /// <summary> Source build number. </summary>
        [WirePath("sourceBuildNumber")]
        public string SourceBuildNumber { get; set; }
        /// <summary> Version with three part. </summary>
        [WirePath("targetClusterVersion")]
        public string TargetClusterVersion { get; set; }
        /// <summary> Version with three part. </summary>
        [WirePath("targetOssVersion")]
        public string TargetOssVersion { get; set; }
        /// <summary> Target build number. </summary>
        [WirePath("targetBuildNumber")]
        public string TargetBuildNumber { get; set; }
        /// <summary> Component name to upgrade. </summary>
        [WirePath("componentName")]
        public string ComponentName { get; set; }
        /// <summary> Severity of this upgrade. </summary>
        [WirePath("severity")]
        public ClusterUpgradeHistorySeverityType? Severity { get; set; }
    }
}
