// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> The compute profile. </summary>
    public partial class ClusterComputeProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterComputeProfile"/>. </summary>
        /// <param name="nodes"> The nodes definitions. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nodes"/> is null. </exception>
        public ClusterComputeProfile(IEnumerable<ClusterComputeNodeProfile> nodes)
        {
            Argument.AssertNotNull(nodes, nameof(nodes));

            Nodes = nodes.ToList();
            AvailabilityZones = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterComputeProfile"/>. </summary>
        /// <param name="nodes"> The nodes definitions. </param>
        /// <param name="availabilityZones"> The list of Availability zones to use for AKS VMSS nodes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterComputeProfile(IList<ClusterComputeNodeProfile> nodes, IList<string> availabilityZones, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Nodes = nodes;
            AvailabilityZones = availabilityZones;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterComputeProfile"/> for deserialization. </summary>
        internal ClusterComputeProfile()
        {
        }

        /// <summary> The nodes definitions. </summary>
        [WirePath("nodes")]
        public IList<ClusterComputeNodeProfile> Nodes { get; }
        /// <summary> The list of Availability zones to use for AKS VMSS nodes. </summary>
        [WirePath("availabilityZones")]
        public IList<string> AvailabilityZones { get; }
    }
}
