// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Type of upgrade. </summary>
    internal readonly partial struct ClusterAvailableUpgradeType : IEquatable<ClusterAvailableUpgradeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterAvailableUpgradeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterAvailableUpgradeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AKSPatchUpgradeValue = "AKSPatchUpgrade";
        private const string HotfixUpgradeValue = "HotfixUpgrade";
        private const string PatchVersionUpgradeValue = "PatchVersionUpgrade";

        /// <summary> AKSPatchUpgrade. </summary>
        public static ClusterAvailableUpgradeType AKSPatchUpgrade { get; } = new ClusterAvailableUpgradeType(AKSPatchUpgradeValue);
        /// <summary> HotfixUpgrade. </summary>
        public static ClusterAvailableUpgradeType HotfixUpgrade { get; } = new ClusterAvailableUpgradeType(HotfixUpgradeValue);
        /// <summary> PatchVersionUpgrade. </summary>
        public static ClusterAvailableUpgradeType PatchVersionUpgrade { get; } = new ClusterAvailableUpgradeType(PatchVersionUpgradeValue);
        /// <summary> Determines if two <see cref="ClusterAvailableUpgradeType"/> values are the same. </summary>
        public static bool operator ==(ClusterAvailableUpgradeType left, ClusterAvailableUpgradeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterAvailableUpgradeType"/> values are not the same. </summary>
        public static bool operator !=(ClusterAvailableUpgradeType left, ClusterAvailableUpgradeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterAvailableUpgradeType"/>. </summary>
        public static implicit operator ClusterAvailableUpgradeType(string value) => new ClusterAvailableUpgradeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterAvailableUpgradeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterAvailableUpgradeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
