// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster available hotfix version upgrade. </summary>
    public partial class ClusterAvailableUpgradeHotfixUpgradeProperties : ClusterAvailableInPlaceUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterAvailableUpgradeHotfixUpgradeProperties"/>. </summary>
        public ClusterAvailableUpgradeHotfixUpgradeProperties()
        {
            UpgradeType = ClusterAvailableUpgradeType.HotfixUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAvailableUpgradeHotfixUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="description"> Hotfix version upgrade description. </param>
        /// <param name="sourceOssVersion"> Source OSS version of current cluster component. </param>
        /// <param name="sourceClusterVersion"> Source cluster version of current cluster component. </param>
        /// <param name="sourceBuildNumber"> Source build number of current cluster component. </param>
        /// <param name="targetOssVersion"> Target OSS version of component to be upgraded. </param>
        /// <param name="targetClusterVersion"> Target cluster version of component to be upgraded. </param>
        /// <param name="targetBuildNumber"> Target build number of component to be upgraded. </param>
        /// <param name="componentName"> Name of component to be upgraded. </param>
        /// <param name="severity"> Severity of this upgrade. </param>
        /// <param name="extendedProperties"> Extended properties of current available upgrade version. </param>
        /// <param name="createdOn"> Created time of current available upgrade version. </param>
        internal ClusterAvailableUpgradeHotfixUpgradeProperties(ClusterAvailableUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string description, string sourceOssVersion, string sourceClusterVersion, string sourceBuildNumber, string targetOssVersion, string targetClusterVersion, string targetBuildNumber, string componentName, ClusterUpgradeSeverityType? severity, string extendedProperties, DateTimeOffset? createdOn) : base(upgradeType, serializedAdditionalRawData, description, sourceOssVersion, sourceClusterVersion, sourceBuildNumber, targetOssVersion, targetClusterVersion, targetBuildNumber, componentName, severity, extendedProperties, createdOn)
        {
            UpgradeType = upgradeType;
        }
    }
}
