// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> Cluster available AKS patch version upgrade. </summary>
    public partial class ClusterAvailableUpgradeAksPatchUpgradeProperties : ClusterAvailableUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterAvailableUpgradeAksPatchUpgradeProperties"/>. </summary>
        public ClusterAvailableUpgradeAksPatchUpgradeProperties()
        {
            UpgradeType = ClusterAvailableUpgradeType.AKSPatchUpgrade;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAvailableUpgradeAksPatchUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="currentVersion"> Current node pool version. </param>
        /// <param name="currentVersionStatus"> Current AKS version's status: whether it is deprecated or supported. </param>
        /// <param name="latestVersion"> Latest available version, which should be equal to AKS control plane version if it's not deprecated. </param>
        internal ClusterAvailableUpgradeAksPatchUpgradeProperties(ClusterAvailableUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string currentVersion, CurrentClusterAksVersionStatus? currentVersionStatus, string latestVersion) : base(upgradeType, serializedAdditionalRawData)
        {
            CurrentVersion = currentVersion;
            CurrentVersionStatus = currentVersionStatus;
            LatestVersion = latestVersion;
            UpgradeType = upgradeType;
        }

        /// <summary> Current node pool version. </summary>
        [WirePath("currentVersion")]
        public string CurrentVersion { get; set; }
        /// <summary> Current AKS version's status: whether it is deprecated or supported. </summary>
        [WirePath("currentVersionStatus")]
        public CurrentClusterAksVersionStatus? CurrentVersionStatus { get; set; }
        /// <summary> Latest available version, which should be equal to AKS control plane version if it's not deprecated. </summary>
        [WirePath("latestVersion")]
        public string LatestVersion { get; set; }
    }
}
