// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary>
    /// Cluster available in-place upgrade.
    /// Please note <see cref="ClusterAvailableInPlaceUpgradeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ClusterAvailableUpgradeHotfixUpgradeProperties"/> and <see cref="ClusterAvailableUpgradePatchVersionUpgradeProperties"/>.
    /// </summary>
    public partial class ClusterAvailableInPlaceUpgradeProperties : ClusterAvailableUpgradeProperties
    {
        /// <summary> Initializes a new instance of <see cref="ClusterAvailableInPlaceUpgradeProperties"/>. </summary>
        public ClusterAvailableInPlaceUpgradeProperties()
        {
            UpgradeType = new ClusterAvailableUpgradeType("ClusterAvailableInPlaceUpgradeProperties");
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAvailableInPlaceUpgradeProperties"/>. </summary>
        /// <param name="upgradeType"> Type of upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="description"> Hotfix version upgrade description. </param>
        /// <param name="sourceOssVersion"> Source OSS version of current cluster component. </param>
        /// <param name="sourceClusterVersion"> Source cluster version of current cluster component. </param>
        /// <param name="sourceBuildNumber"> Source build number of current cluster component. </param>
        /// <param name="targetOssVersion"> Target OSS version of component to be upgraded. </param>
        /// <param name="targetClusterVersion"> Target cluster version of component to be upgraded. </param>
        /// <param name="targetBuildNumber"> Target build number of component to be upgraded. </param>
        /// <param name="componentName"> Name of component to be upgraded. </param>
        /// <param name="severity"> Severity of this upgrade. </param>
        /// <param name="extendedProperties"> Extended properties of current available upgrade version. </param>
        /// <param name="createdOn"> Created time of current available upgrade version. </param>
        internal ClusterAvailableInPlaceUpgradeProperties(ClusterAvailableUpgradeType upgradeType, IDictionary<string, BinaryData> serializedAdditionalRawData, string description, string sourceOssVersion, string sourceClusterVersion, string sourceBuildNumber, string targetOssVersion, string targetClusterVersion, string targetBuildNumber, string componentName, ClusterUpgradeSeverityType? severity, string extendedProperties, DateTimeOffset? createdOn) : base(upgradeType, serializedAdditionalRawData)
        {
            Description = description;
            SourceOssVersion = sourceOssVersion;
            SourceClusterVersion = sourceClusterVersion;
            SourceBuildNumber = sourceBuildNumber;
            TargetOssVersion = targetOssVersion;
            TargetClusterVersion = targetClusterVersion;
            TargetBuildNumber = targetBuildNumber;
            ComponentName = componentName;
            Severity = severity;
            ExtendedProperties = extendedProperties;
            CreatedOn = createdOn;
            UpgradeType = upgradeType;
        }

        /// <summary> Hotfix version upgrade description. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Source OSS version of current cluster component. </summary>
        [WirePath("sourceOssVersion")]
        public string SourceOssVersion { get; set; }
        /// <summary> Source cluster version of current cluster component. </summary>
        [WirePath("sourceClusterVersion")]
        public string SourceClusterVersion { get; set; }
        /// <summary> Source build number of current cluster component. </summary>
        [WirePath("sourceBuildNumber")]
        public string SourceBuildNumber { get; set; }
        /// <summary> Target OSS version of component to be upgraded. </summary>
        [WirePath("targetOssVersion")]
        public string TargetOssVersion { get; set; }
        /// <summary> Target cluster version of component to be upgraded. </summary>
        [WirePath("targetClusterVersion")]
        public string TargetClusterVersion { get; set; }
        /// <summary> Target build number of component to be upgraded. </summary>
        [WirePath("targetBuildNumber")]
        public string TargetBuildNumber { get; set; }
        /// <summary> Name of component to be upgraded. </summary>
        [WirePath("componentName")]
        public string ComponentName { get; set; }
        /// <summary> Severity of this upgrade. </summary>
        [WirePath("severity")]
        public ClusterUpgradeSeverityType? Severity { get; set; }
        /// <summary> Extended properties of current available upgrade version. </summary>
        [WirePath("extendedProperties")]
        public string ExtendedProperties { get; set; }
        /// <summary> Created time of current available upgrade version. </summary>
        [WirePath("createdTime")]
        public DateTimeOffset? CreatedOn { get; set; }
    }
}
