// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HDInsight.Containers.Models
{
    /// <summary> This is the Autoscale profile for the cluster. This will allow customer to create cluster enabled with Autoscale. </summary>
    public partial class ClusterAutoscaleProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterAutoscaleProfile"/>. </summary>
        /// <param name="isEnabled"> This indicates whether auto scale is enabled on HDInsight on AKS cluster. </param>
        public ClusterAutoscaleProfile(bool isEnabled)
        {
            IsEnabled = isEnabled;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAutoscaleProfile"/>. </summary>
        /// <param name="isEnabled"> This indicates whether auto scale is enabled on HDInsight on AKS cluster. </param>
        /// <param name="gracefulDecommissionTimeout"> This property is for graceful decommission timeout; It has a default setting of 3600 seconds before forced shutdown takes place. This is the maximal time to wait for running containers and applications to complete before transition a DECOMMISSIONING node into DECOMMISSIONED. The default value is 3600 seconds. Negative value (like -1) is handled as infinite timeout. </param>
        /// <param name="autoscaleType"> User to specify which type of Autoscale to be implemented - Scheduled Based or Load Based. </param>
        /// <param name="scheduleBasedConfig"> Profiles of schedule based Autoscale. </param>
        /// <param name="loadBasedConfig"> Profiles of load based Autoscale. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterAutoscaleProfile(bool isEnabled, int? gracefulDecommissionTimeout, ClusterAutoscaleType? autoscaleType, ScheduleBasedConfig scheduleBasedConfig, LoadBasedConfig loadBasedConfig, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            GracefulDecommissionTimeout = gracefulDecommissionTimeout;
            AutoscaleType = autoscaleType;
            ScheduleBasedConfig = scheduleBasedConfig;
            LoadBasedConfig = loadBasedConfig;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAutoscaleProfile"/> for deserialization. </summary>
        internal ClusterAutoscaleProfile()
        {
        }

        /// <summary> This indicates whether auto scale is enabled on HDInsight on AKS cluster. </summary>
        [WirePath("enabled")]
        public bool IsEnabled { get; set; }
        /// <summary> This property is for graceful decommission timeout; It has a default setting of 3600 seconds before forced shutdown takes place. This is the maximal time to wait for running containers and applications to complete before transition a DECOMMISSIONING node into DECOMMISSIONED. The default value is 3600 seconds. Negative value (like -1) is handled as infinite timeout. </summary>
        [WirePath("gracefulDecommissionTimeout")]
        public int? GracefulDecommissionTimeout { get; set; }
        /// <summary> User to specify which type of Autoscale to be implemented - Scheduled Based or Load Based. </summary>
        [WirePath("autoscaleType")]
        public ClusterAutoscaleType? AutoscaleType { get; set; }
        /// <summary> Profiles of schedule based Autoscale. </summary>
        [WirePath("scheduleBasedConfig")]
        public ScheduleBasedConfig ScheduleBasedConfig { get; set; }
        /// <summary> Profiles of load based Autoscale. </summary>
        [WirePath("loadBasedConfig")]
        public LoadBasedConfig LoadBasedConfig { get; set; }
    }
}
